/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class EntityThrowableCopy
extends Entity
implements IProjectile {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    protected boolean inGround;
    public int throwableShake;
    protected LivingEntity owner;
    private UUID ownerId;
    private Entity ignoreEntity;
    private int ignoreTime;

    protected EntityThrowableCopy(EntityType<? extends EntityThrowableCopy> p_i48540_1_, World p_i48540_2_) {
        super(p_i48540_1_, p_i48540_2_);
    }

    protected EntityThrowableCopy(EntityType<? extends EntityThrowableCopy> p_i48541_1_, double p_i48541_2_, double p_i48541_4_, double p_i48541_6_, World p_i48541_8_) {
        this(p_i48541_1_, p_i48541_8_);
        this.func_70107_b(p_i48541_2_, p_i48541_4_, p_i48541_6_);
    }

    protected EntityThrowableCopy(EntityType<? extends EntityThrowableCopy> p_i48542_1_, LivingEntity p_i48542_2_, World p_i48542_3_) {
        this(p_i48542_1_, p_i48542_2_.func_226277_ct_(), p_i48542_2_.func_226280_cw_() - (double)0.1f, p_i48542_2_.func_226281_cx_(), p_i48542_3_);
        this.owner = p_i48542_2_;
        this.ownerId = p_i48542_2_.func_110124_au();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return p_70112_1_ < (d0 *= 64.0) * d0;
    }

    public void shoot(Entity p_184538_1_, float p_184538_2_, float p_184538_3_, float p_184538_4_, float p_184538_5_, float p_184538_6_) {
        float f = -MathHelper.func_76126_a((float)(p_184538_3_ * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(p_184538_2_ * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((p_184538_2_ + p_184538_4_) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(p_184538_3_ * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(p_184538_2_ * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, p_184538_5_, p_184538_6_);
        Vec3d vec3d = p_184538_1_.func_213322_ci();
        this.func_213317_d(this.func_213322_ci().func_72441_c(vec3d.field_72450_a, p_184538_1_.field_70122_E ? 0.0 : vec3d.field_72448_b, vec3d.field_72449_c));
    }

    public void func_70186_c(double p_70186_1_, double p_70186_3_, double p_70186_5_, float p_70186_7_, float p_70186_8_) {
        Vec3d vec3d = new Vec3d(p_70186_1_, p_70186_3_, p_70186_5_).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)p_70186_8_, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)p_70186_8_, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)p_70186_8_).func_186678_a((double)p_70186_7_);
        this.func_213317_d(vec3d);
        float f = MathHelper.func_76133_a((double)EntityThrowableCopy.func_213296_b((Vec3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double p_70016_1_, double p_70016_3_, double p_70016_5_) {
        this.func_213293_j(p_70016_1_, p_70016_3_, p_70016_5_);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(p_70016_1_ * p_70016_1_ + p_70016_5_ * p_70016_5_));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)p_70016_1_, (double)p_70016_5_) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)p_70016_3_, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    public void func_70071_h_() {
        float f1;
        super.func_70071_h_();
        if (this.throwableShake > 0) {
            --this.throwableShake;
        }
        if (this.inGround) {
            this.inGround = false;
            this.func_213317_d(this.func_213322_ci().func_216372_d((double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f)));
        }
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0);
        for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, axisalignedbb, p_213881_0_ -> !p_213881_0_.func_175149_v() && p_213881_0_.func_70067_L())) {
            if (entity == this.ignoreEntity) {
                ++this.ignoreTime;
                break;
            }
            if (this.owner == null || this.field_70173_aa >= 2 || this.ignoreEntity != null) continue;
            this.ignoreEntity = entity;
            this.ignoreTime = 3;
            break;
        }
        RayTraceResult raytraceresult = ProjectileHelper.func_221267_a((Entity)this, (AxisAlignedBB)axisalignedbb, p_213880_1_ -> !p_213880_1_.func_175149_v() && p_213880_1_.func_70067_L() && p_213880_1_ != this.ignoreEntity, (RayTraceContext.BlockMode)RayTraceContext.BlockMode.OUTLINE, (boolean)true);
        if (this.ignoreEntity != null && this.ignoreTime-- <= 0) {
            this.ignoreEntity = null;
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(((BlockRayTraceResult)raytraceresult).func_216350_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(((BlockRayTraceResult)raytraceresult).func_216350_a());
            } else if (!ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                this.onImpact(raytraceresult);
            }
        }
        Vec3d vec3d = this.func_213322_ci();
        double d0 = this.func_226277_ct_() + vec3d.field_72450_a;
        double d1 = this.func_226278_cu_() + vec3d.field_72448_b;
        double d2 = this.func_226281_cx_() + vec3d.field_72449_c;
        float f = MathHelper.func_76133_a((double)EntityThrowableCopy.func_213296_b((Vec3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float f2 = 0.25f;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d0 - vec3d.field_72450_a * 0.25, d1 - vec3d.field_72448_b * 0.25, d2 - vec3d.field_72449_c * 0.25, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
            }
            f1 = 0.8f;
        } else {
            f1 = 0.99f;
        }
        this.func_213317_d(vec3d.func_186678_a((double)f1));
        if (!this.func_189652_ae()) {
            Vec3d vec3d1 = this.func_213322_ci();
            this.func_213293_j(vec3d1.field_72450_a, vec3d1.field_72448_b - (double)this.getGravityVelocity(), vec3d1.field_72449_c);
        }
        this.func_70107_b(d0, d1, d2);
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    protected abstract void onImpact(RayTraceResult var1);

    public void func_213281_b(CompoundNBT p_213281_1_) {
        p_213281_1_.func_74768_a("xTile", this.xTile);
        p_213281_1_.func_74768_a("yTile", this.yTile);
        p_213281_1_.func_74768_a("zTile", this.zTile);
        p_213281_1_.func_74774_a("shake", (byte)this.throwableShake);
        p_213281_1_.func_74757_a("inGround", this.inGround);
        if (this.ownerId != null) {
            p_213281_1_.func_218657_a("owner", (INBT)NBTUtil.func_186862_a((UUID)this.ownerId));
        }
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        this.xTile = p_70037_1_.func_74762_e("xTile");
        this.yTile = p_70037_1_.func_74762_e("yTile");
        this.zTile = p_70037_1_.func_74762_e("zTile");
        this.throwableShake = p_70037_1_.func_74771_c("shake") & 0xFF;
        this.inGround = p_70037_1_.func_74767_n("inGround");
        this.owner = null;
        if (p_70037_1_.func_150297_b("owner", 10)) {
            this.ownerId = NBTUtil.func_186860_b((CompoundNBT)p_70037_1_.func_74775_l("owner"));
        }
    }

    @Nullable
    public LivingEntity getThrower() {
        if ((this.owner == null || this.owner.field_70128_L) && this.ownerId != null && this.field_70170_p instanceof ServerWorld) {
            Entity entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.ownerId);
            this.owner = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        }
        return this.owner;
    }

    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this);
    }
}

