/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.lens.ItemLens;

public class LensDyeingRecipe
extends SpecialRecipe {
    public static final SpecialRecipeSerializer<LensDyeingRecipe> SERIALIZER = new SpecialRecipeSerializer(LensDyeingRecipe::new);
    private final List<Ingredient> dyes = Arrays.asList(Ingredient.func_199805_a((Tag)Tags.Items.DYES_WHITE), Ingredient.func_199805_a((Tag)Tags.Items.DYES_ORANGE), Ingredient.func_199805_a((Tag)Tags.Items.DYES_MAGENTA), Ingredient.func_199805_a((Tag)Tags.Items.DYES_LIGHT_BLUE), Ingredient.func_199805_a((Tag)Tags.Items.DYES_YELLOW), Ingredient.func_199805_a((Tag)Tags.Items.DYES_LIME), Ingredient.func_199805_a((Tag)Tags.Items.DYES_PINK), Ingredient.func_199805_a((Tag)Tags.Items.DYES_GRAY), Ingredient.func_199805_a((Tag)Tags.Items.DYES_LIGHT_GRAY), Ingredient.func_199805_a((Tag)Tags.Items.DYES_CYAN), Ingredient.func_199805_a((Tag)Tags.Items.DYES_PURPLE), Ingredient.func_199805_a((Tag)Tags.Items.DYES_BLUE), Ingredient.func_199805_a((Tag)Tags.Items.DYES_BROWN), Ingredient.func_199805_a((Tag)Tags.Items.DYES_GREEN), Ingredient.func_199805_a((Tag)Tags.Items.DYES_RED), Ingredient.func_199805_a((Tag)Tags.Items.DYES_BLACK), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.manaPearl}));

    public LensDyeingRecipe(ResourceLocation id) {
        super(id);
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World world) {
        boolean foundLens = false;
        boolean foundDye = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ILens && !foundLens) {
                foundLens = true;
                continue;
            }
            if (!foundDye) {
                int color = this.getStackColor(stack);
                if (color > -1) {
                    foundDye = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        return foundLens && foundDye;
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        ItemStack lens = ItemStack.field_190927_a;
        int color = -1;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ILens && lens.func_190926_b()) {
                lens = stack;
                continue;
            }
            color = this.getStackColor(stack);
        }
        if (lens.func_77973_b() instanceof ILens) {
            ItemStack lensCopy = lens.func_77946_l();
            ItemLens.setLensColor(lensCopy, color);
            return lensCopy;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    private int getStackColor(ItemStack stack) {
        for (int i = 0; i < this.dyes.size(); ++i) {
            if (!this.dyes.get(i).test(stack)) continue;
            return i;
        }
        return -1;
    }
}

