/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.CratePattern;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.common.block.BlockOpenCrate;
import vazkii.botania.common.block.tile.TileCraftCrate;

public class BlockCraftyCrate
extends BlockOpenCrate
implements IWandHUD {
    public BlockCraftyCrate(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(BotaniaStateProps.CRATE_PATTERN, (Comparable)((Object)CratePattern.NONE)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BotaniaStateProps.CRATE_PATTERN});
    }

    @Override
    @Nonnull
    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return new TileCraftCrate();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(Minecraft mc, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCraftCrate) {
            TileCraftCrate craft = (TileCraftCrate)tile;
            int width = 52;
            int height = 52;
            int xc = mc.func_228018_at_().func_198107_o() / 2 + 20;
            int yc = mc.func_228018_at_().func_198087_p() / 2 - height / 2;
            AbstractGui.fill((int)(xc - 6), (int)(yc - 6), (int)(xc + width + 6), (int)(yc + height + 6), (int)0x22000000);
            AbstractGui.fill((int)(xc - 4), (int)(yc - 4), (int)(xc + width + 4), (int)(yc + height + 4), (int)0x22000000);
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int index = i * 3 + j;
                    int xp = xc + j * 18;
                    int yp = yc + i * 18;
                    boolean enabled = true;
                    if (craft.getPattern() != CratePattern.NONE) {
                        enabled = craft.getPattern().openSlots.get(index);
                    }
                    AbstractGui.fill((int)xp, (int)yp, (int)(xp + 16), (int)(yp + 16), (int)(enabled ? 0x22FFFFFF : 0x22FF0000));
                    ItemStack item = craft.getItemHandler().getStackInSlot(index);
                    mc.func_175599_af().func_180450_b(item, xp, yp);
                }
            }
        }
    }
}

