/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import vazkii.botania.api.state.enums.LuminizerVariant;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.BlockLightRelay;
import vazkii.botania.common.block.tile.TileLightRelay;

public class RenderTileLightRelay
extends TileEntityRenderer<TileLightRelay> {
    private static Map<LuminizerVariant, TextureAtlasSprite> sprites = new EnumMap<LuminizerVariant, TextureAtlasSprite>(LuminizerVariant.class);

    public RenderTileLightRelay(TileEntityRendererDispatcher manager) {
        super(manager);
    }

    public void render(@Nonnull TileLightRelay tile, float pticks, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        BlockState state = tile.func_195044_w();
        if (!(state.func_177230_c() instanceof BlockLightRelay)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (sprites.isEmpty()) {
            sprites.put(LuminizerVariant.DEFAULT, MiscellaneousIcons.INSTANCE.lightRelayWorldIcon);
            sprites.put(LuminizerVariant.DETECTOR, MiscellaneousIcons.INSTANCE.lightRelayWorldIconRed);
            sprites.put(LuminizerVariant.FORK, MiscellaneousIcons.INSTANCE.lightRelayWorldIconGreen);
            sprites.put(LuminizerVariant.TOGGLE, MiscellaneousIcons.INSTANCE.lightRelayWorldIconPurple);
        }
        TextureAtlasSprite iicon = sprites.get((Object)((BlockLightRelay)state.func_177230_c()).variant);
        ms.func_227860_a_();
        ms.func_227861_a_(0.5, 0.3, 0.5);
        double time = (float)ClientTickHandler.ticksInGame + pticks;
        float scale = 0.75f;
        ms.func_227862_a_(scale, scale, scale);
        ms.func_227863_a_(mc.func_175598_ae().func_229098_b_());
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        float off = 0.25f;
        ms.func_227861_a_(0.0, (double)off, 0.0);
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)time));
        ms.func_227861_a_(0.0, (double)(-off), 0.0);
        IVertexBuilder buffer = buffers.getBuffer(RenderHelper.LIGHT_RELAY);
        this.renderIcon(ms, buffer, iicon);
        ms.func_227865_b_();
    }

    private void renderIcon(MatrixStack ms, IVertexBuilder buffer, TextureAtlasSprite icon) {
        float size = icon.func_94212_f() - icon.func_94209_e();
        float pad = size / 8.0f;
        float f = icon.func_94209_e() + pad;
        float f1 = icon.func_94212_f() - pad;
        float f2 = icon.func_94206_g() + pad;
        float f3 = icon.func_94210_h() - pad;
        float f4 = 1.0f;
        float f5 = 0.5f;
        float f6 = 0.25f;
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        int fullbright = 0xF000F0;
        buffer.func_227888_a_(mat, 0.0f - f5, 0.0f - f6, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(f, f3).func_227886_a_(fullbright).func_181675_d();
        buffer.func_227888_a_(mat, f4 - f5, 0.0f - f6, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(f1, f3).func_227886_a_(fullbright).func_181675_d();
        buffer.func_227888_a_(mat, f4 - f5, f4 - f6, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(f1, f2).func_227886_a_(fullbright).func_181675_d();
        buffer.func_227888_a_(mat, 0.0f - f5, f4 - f6, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(f, f2).func_227886_a_(fullbright).func_181675_d();
    }
}

