/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.mana.IManaTooltipDisplay;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="botania")
public final class TooltipAdditionDisplayHandler {
    @SubscribeEvent
    public static void onToolTipRender(RenderTooltipEvent.PostText evt) {
        if (evt.getStack().func_190926_b()) {
            return;
        }
        ItemStack stack = evt.getStack();
        int width = evt.getWidth();
        int height = 3;
        int tooltipX = evt.getX();
        int tooltipY = evt.getY() - 4;
        FontRenderer font = evt.getFontRenderer();
        if (stack.func_77973_b() instanceof ItemTerraPick) {
            TooltipAdditionDisplayHandler.drawTerraPick(stack, tooltipX, tooltipY, width, height, font);
        } else if (stack.func_77973_b() instanceof IManaTooltipDisplay) {
            TooltipAdditionDisplayHandler.drawManaBar(stack, (IManaTooltipDisplay)stack.func_77973_b(), tooltipX, tooltipY, width, height);
        }
    }

    private static void drawTerraPick(ItemStack stack, int mouseX, int mouseY, int width, int height, FontRenderer font) {
        int level = ItemTerraPick.getLevel(stack);
        int max = ItemTerraPick.LEVELS[Math.min(ItemTerraPick.LEVELS.length - 1, level + 1)];
        boolean ss = level >= ItemTerraPick.LEVELS.length - 1;
        int curr = ItemTerraPick.getMana_(stack);
        float percent = level == 0 ? 0.0f : (float)curr / (float)max;
        int rainbowWidth = Math.min(width - (ss ? 0 : 1), (int)((float)width * percent));
        float huePer = width == 0 ? 0.0f : 1.0f / (float)width;
        float hueOff = ((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) * 0.01f;
        RenderSystem.disableDepthTest();
        AbstractGui.fill((int)(mouseX - 1), (int)(mouseY - height - 1), (int)(mouseX + width + 1), (int)mouseY, (int)-16777216);
        for (int i = 0; i < rainbowWidth; ++i) {
            AbstractGui.fill((int)(mouseX + i), (int)(mouseY - height), (int)(mouseX + i + 1), (int)mouseY, (int)(0xFF000000 | MathHelper.func_181758_c((float)((hueOff + huePer * (float)i) % 1.0f), (float)1.0f, (float)1.0f)));
        }
        AbstractGui.fill((int)(mouseX + rainbowWidth), (int)(mouseY - height), (int)(mouseX + width), (int)mouseY, (int)-11184811);
        String rank = I18n.func_135052_a((String)("botania.rank" + level), (Object[])new Object[0]).replaceAll("&", "\u00a7");
        GL11.glPushAttrib((int)64);
        RenderSystem.disableLighting();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)300.0f);
        font.func_175063_a(rank, (float)mouseX, (float)(mouseY - 12), 0xFFFFFF);
        if (!ss) {
            rank = I18n.func_135052_a((String)("botania.rank" + (level + 1)), (Object[])new Object[0]).replaceAll("&", "\u00a7");
            font.func_175063_a(rank, (float)(mouseX + width - font.func_78256_a(rank)), (float)(mouseY - 12), 0xFFFFFF);
        }
        RenderSystem.popMatrix();
        RenderSystem.enableLighting();
        RenderSystem.enableDepthTest();
        GL11.glPopAttrib();
    }

    private static void drawManaBar(ItemStack stack, IManaTooltipDisplay display, int mouseX, int mouseY, int width, int height) {
        float fraction = display.getManaFractionForDisplay(stack);
        int manaBarWidth = (int)Math.ceil((float)width * fraction);
        RenderSystem.disableDepthTest();
        AbstractGui.fill((int)(mouseX - 1), (int)(mouseY - height - 1), (int)(mouseX + width + 1), (int)mouseY, (int)-16777216);
        AbstractGui.fill((int)mouseX, (int)(mouseY - height), (int)(mouseX + manaBarWidth), (int)mouseY, (int)(0xFF000000 | MathHelper.func_181758_c((float)0.528f, (float)(((float)Math.sin((double)((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) * 0.2) + 1.0f) * 0.3f + 0.4f), (float)1.0f)));
        AbstractGui.fill((int)(mouseX + manaBarWidth), (int)(mouseY - height), (int)(mouseX + width), (int)mouseY, (int)-11184811);
    }
}

