/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.corporea;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaResult;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.corporea.InvWithLocation;

public interface CorporeaHelper {
    public static final LazyValue<CorporeaHelper> INSTANCE = new LazyValue(() -> {
        try {
            return (CorporeaHelper)Class.forName("vazkii.botania.common.impl.corporea.CorporeaHelperImpl").newInstance();
        }
        catch (ReflectiveOperationException e) {
            LogManager.getLogger().warn("Unable to find CorporeaHelperImpl, using a dummy");
            return new CorporeaHelper(){};
        }
    });

    public static CorporeaHelper instance() {
        return (CorporeaHelper)INSTANCE.func_179281_c();
    }

    default public List<InvWithLocation> getInventoriesOnNetwork(ICorporeaSpark spark) {
        return Collections.emptyList();
    }

    default public int getCountInNetwork(ICorporeaRequestMatcher matcher, ICorporeaSpark spark) {
        return 0;
    }

    default public int getCountInNetwork(ICorporeaRequestMatcher matcher, List<InvWithLocation> inventories) {
        return 0;
    }

    default public int getCountInNetwork(ICorporeaRequestMatcher matcher, Map<InvWithLocation, Integer> inventories) {
        return 0;
    }

    default public Map<InvWithLocation, Integer> getInventoriesWithMatchInNetwork(ICorporeaRequestMatcher matcher, ICorporeaSpark spark) {
        return Collections.emptyMap();
    }

    default public Map<InvWithLocation, Integer> getInventoriesWithMatchInNetwork(ICorporeaRequestMatcher matcher, List<InvWithLocation> inventories) {
        return Collections.emptyMap();
    }

    default public ICorporeaRequestMatcher createMatcher(ItemStack stack, boolean checkNBT) {
        return ICorporeaRequestMatcher.Dummy.INSTANCE;
    }

    default public ICorporeaRequestMatcher createMatcher(String name) {
        return ICorporeaRequestMatcher.Dummy.INSTANCE;
    }

    default public ICorporeaResult requestItem(ItemStack stack, ICorporeaSpark spark, boolean checkNBT, boolean doit) {
        return this.requestItem(this.createMatcher(stack, checkNBT), stack.func_190916_E(), spark, doit);
    }

    default public ICorporeaResult requestItem(String name, int count, ICorporeaSpark spark, boolean doit) {
        return this.requestItem(this.createMatcher(name), count, spark, doit);
    }

    default public ICorporeaResult requestItem(ICorporeaRequestMatcher matcher, int itemCount, ICorporeaSpark spark, boolean doit) {
        return ICorporeaResult.Dummy.INSTANCE;
    }

    @Nullable
    default public ICorporeaSpark getSparkForInventory(InvWithLocation inv) {
        return null;
    }

    @Nullable
    default public ICorporeaSpark getSparkForBlock(World world, BlockPos pos) {
        return null;
    }

    default public boolean doesBlockHaveSpark(World world, BlockPos pos) {
        return this.getSparkForBlock(world, pos) != null;
    }

    default public int signalStrengthForRequestSize(int requestSize) {
        return 0;
    }

    default public <T extends ICorporeaRequestMatcher> void registerRequestMatcher(ResourceLocation id, Class<T> clazz, Function<CompoundNBT, T> deserializer) {
    }
}

