/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemDrawers
extends BlockItem {
    public ItemDrawers(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new TranslationTextComponent("tooltip.storagedrawers.drawers.capacity", new Object[]{this.getCapacityForBlock(stack)}).func_211708_a(TextFormatting.GRAY));
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("tile")) {
            tooltip.add(new TranslationTextComponent("tooltip.storagedrawers.drawers.sealed", new Object[0]).func_211708_a(TextFormatting.YELLOW));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected ITextComponent getDescription() {
        return new TranslationTextComponent(this.func_77658_a() + ".desc", new Object[0]);
    }

    private int getCapacityForBlock(@Nonnull ItemStack itemStack) {
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        if (block instanceof BlockDrawers) {
            BlockDrawers drawers = (BlockDrawers)block;
            return drawers.getStorageUnits() * CommonConfig.GENERAL.getBaseStackStorage();
        }
        return 0;
    }
}

