/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.google.common.collect.Lists;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.client.model.ProxyBuilderModel;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.mojang.datafixers.util.Either;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResource;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.io.IOUtils;

public final class BasicDrawerModel {
    private static final Map<Direction, IBakedModel> lockOverlaysFull = new HashMap<Direction, IBakedModel>();
    private static final Map<Direction, IBakedModel> lockOverlaysHalf = new HashMap<Direction, IBakedModel>();
    private static boolean geometryDataLoaded = false;

    public static class Model
    extends ProxyBuilderModel {
        Direction side;
        Map<Direction, IBakedModel> overlays;

        public Model(IBakedModel parent, Map<Direction, IBakedModel> overlays, Direction side) {
            super(parent);
            this.overlays = overlays;
            this.side = side;
        }

        @Override
        protected IBakedModel buildModel(BlockState state, IBakedModel parent) {
            return new MergedModel(parent, this.overlays.get(this.side));
        }
    }

    public static abstract class Model2
    implements IDynamicBakedModel {
        protected final IBakedModel mainModel;
        protected final Map<Direction, IBakedModel> lockOverlay;

        private Model2(IBakedModel mainModel, Map<Direction, IBakedModel> lockOverlay) {
            this.mainModel = mainModel;
            this.lockOverlay = lockOverlay;
        }

        public boolean func_230044_c_() {
            return this.mainModel.func_230044_c_();
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            ArrayList quads = Lists.newArrayList();
            quads.addAll(this.mainModel.func_200117_a(state, side, rand));
            if (state != null && extraData.hasProperty(TileEntityDrawers.ATTRIBUTES)) {
                IDrawerAttributes attr = (IDrawerAttributes)extraData.getData(TileEntityDrawers.ATTRIBUTES);
                Direction dir = (Direction)state.func_177229_b((IProperty)BlockDrawers.field_185512_D);
                if (attr.isItemLocked(LockAttribute.LOCK_EMPTY) || attr.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                    quads.addAll(this.lockOverlay.get(dir).getQuads(state, side, rand, extraData));
                }
            }
            return quads;
        }

        public boolean func_177555_b() {
            return this.mainModel.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.mainModel.func_177556_c();
        }

        public boolean func_188618_c() {
            return this.mainModel.func_188618_c();
        }

        public TextureAtlasSprite func_177554_e() {
            return this.mainModel.func_177554_e();
        }

        public ItemOverrideList func_188617_f() {
            return this.mainModel.func_188617_f();
        }

        public static class HalfModel
        extends Model2 {
            HalfModel(IBakedModel mainModel) {
                super(mainModel, lockOverlaysHalf);
            }
        }

        public static class FullModel
        extends Model2 {
            FullModel(IBakedModel mainModel) {
                super(mainModel, lockOverlaysFull);
            }
        }
    }

    public static class MergedModel
    implements IBakedModel {
        protected final IBakedModel mainModel;
        protected final IBakedModel[] models;

        public MergedModel(IBakedModel mainModel, IBakedModel ... models) {
            this.mainModel = mainModel;
            this.models = models;
        }

        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            ArrayList quads = Lists.newArrayList();
            quads.addAll(this.mainModel.func_200117_a(state, side, rand));
            for (IBakedModel model : this.models) {
                quads.addAll(model.func_200117_a(state, side, rand));
            }
            return quads;
        }

        public boolean func_177555_b() {
            return this.mainModel.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.mainModel.func_177556_c();
        }

        public boolean func_230044_c_() {
            return this.mainModel.func_230044_c_();
        }

        public boolean func_188618_c() {
            return this.mainModel.func_188618_c();
        }

        public TextureAtlasSprite func_177554_e() {
            return this.mainModel.func_177554_e();
        }

        public ItemOverrideList func_188617_f() {
            return this.mainModel.func_188617_f();
        }
    }

    @Mod.EventBusSubscriber(modid="storagedrawers", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class Register {
        @SubscribeEvent
        public static void registerTextures(TextureStitchEvent.Pre event) {
            BlockModel unbakedModel = Register.getBlockModel(new ResourceLocation("storagedrawers", "models/block/full_drawers_lock.json"));
            for (Either x : unbakedModel.field_178318_c.values()) {
                x.ifLeft(value -> {
                    if (value.func_229310_a_().equals((Object)event.getMap().func_229223_g_())) {
                        event.addSprite(value.func_229313_b_());
                    }
                });
            }
            Register.loadGeometryData();
        }

        private static void loadGeometryData() {
            if (geometryDataLoaded) {
                return;
            }
            geometryDataLoaded = true;
            Register.populateGeometryData(new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_icon_area_1.json"), new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_count_area_1.json"), ModBlocks.OAK_FULL_DRAWERS_1, ModBlocks.SPRUCE_FULL_DRAWERS_1, ModBlocks.BIRCH_FULL_DRAWERS_1, ModBlocks.JUNGLE_FULL_DRAWERS_1, ModBlocks.ACACIA_FULL_DRAWERS_1, ModBlocks.DARK_OAK_FULL_DRAWERS_1);
            Register.populateGeometryData(new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_icon_area_2.json"), new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_count_area_2.json"), ModBlocks.OAK_FULL_DRAWERS_2, ModBlocks.SPRUCE_FULL_DRAWERS_2, ModBlocks.BIRCH_FULL_DRAWERS_2, ModBlocks.JUNGLE_FULL_DRAWERS_2, ModBlocks.ACACIA_FULL_DRAWERS_2, ModBlocks.DARK_OAK_FULL_DRAWERS_2);
            Register.populateGeometryData(new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_icon_area_4.json"), new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_count_area_4.json"), ModBlocks.OAK_FULL_DRAWERS_4, ModBlocks.SPRUCE_FULL_DRAWERS_4, ModBlocks.BIRCH_FULL_DRAWERS_4, ModBlocks.JUNGLE_FULL_DRAWERS_4, ModBlocks.ACACIA_FULL_DRAWERS_4, ModBlocks.DARK_OAK_FULL_DRAWERS_4);
            Register.populateGeometryData(new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_icon_area_1.json"), new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_count_area_1.json"), ModBlocks.OAK_HALF_DRAWERS_1, ModBlocks.SPRUCE_HALF_DRAWERS_1, ModBlocks.BIRCH_HALF_DRAWERS_1, ModBlocks.JUNGLE_HALF_DRAWERS_1, ModBlocks.ACACIA_HALF_DRAWERS_1, ModBlocks.DARK_OAK_HALF_DRAWERS_1);
            Register.populateGeometryData(new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_icon_area_2.json"), new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_count_area_2.json"), ModBlocks.OAK_HALF_DRAWERS_2, ModBlocks.SPRUCE_HALF_DRAWERS_2, ModBlocks.BIRCH_HALF_DRAWERS_2, ModBlocks.JUNGLE_HALF_DRAWERS_2, ModBlocks.ACACIA_HALF_DRAWERS_2, ModBlocks.DARK_OAK_HALF_DRAWERS_2);
            Register.populateGeometryData(new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_icon_area_4.json"), new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_count_area_4.json"), ModBlocks.OAK_HALF_DRAWERS_4, ModBlocks.SPRUCE_HALF_DRAWERS_4, ModBlocks.BIRCH_HALF_DRAWERS_4, ModBlocks.JUNGLE_HALF_DRAWERS_4, ModBlocks.ACACIA_HALF_DRAWERS_4, ModBlocks.DARK_OAK_HALF_DRAWERS_4);
            Register.populateGeometryData(new ResourceLocation("storagedrawers", "models/block/geometry/comp_drawers_icon_area_3.json"), new ResourceLocation("storagedrawers", "models/block/geometry/comp_drawers_count_area_3.json"), ModBlocks.COMPACTING_DRAWERS_3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static BlockModel getBlockModel(ResourceLocation location) {
            BlockModel blockModel;
            IResource iresource = null;
            InputStreamReader reader = null;
            try {
                iresource = Minecraft.func_71410_x().func_195551_G().func_199002_a(location);
                reader = new InputStreamReader(iresource.func_199027_b(), StandardCharsets.UTF_8);
                blockModel = BlockModel.func_178307_a((Reader)reader);
                IOUtils.closeQuietly((Reader)reader);
            }
            catch (IOException e) {
                BlockModel blockModel2 = null;
                return blockModel2;
            }
            finally {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly((Closeable)iresource);
            }
            IOUtils.closeQuietly((Closeable)iresource);
            return blockModel;
        }

        private static void populateGeometryData(ResourceLocation locationIcon, ResourceLocation locationCount, BlockDrawers ... blocks) {
            BlockModel slotInfo = Register.getBlockModel(locationIcon);
            BlockModel countInfo = Register.getBlockModel(locationCount);
            for (BlockDrawers block : blocks) {
                Vector3f to;
                Vector3f from;
                int i;
                if (block == null) continue;
                for (i = 0; i < block.getDrawerCount(); ++i) {
                    from = ((BlockPart)slotInfo.func_178298_a().get((int)i)).field_178241_a;
                    to = ((BlockPart)slotInfo.func_178298_a().get((int)i)).field_178239_b;
                    block.labelGeometry[i] = new AxisAlignedBB((double)from.func_195899_a(), (double)from.func_195900_b(), (double)from.func_195902_c(), (double)to.func_195899_a(), (double)to.func_195900_b(), (double)to.func_195902_c());
                }
                for (i = 0; i < block.getDrawerCount(); ++i) {
                    from = ((BlockPart)countInfo.func_178298_a().get((int)i)).field_178241_a;
                    to = ((BlockPart)countInfo.func_178298_a().get((int)i)).field_178239_b;
                    block.countGeometry[i] = new AxisAlignedBB((double)from.func_195899_a(), (double)from.func_195900_b(), (double)from.func_195902_c(), (double)to.func_195899_a(), (double)to.func_195900_b(), (double)to.func_195902_c());
                }
            }
        }

        @SubscribeEvent
        public static void registerModels(ModelBakeEvent event) {
            lockOverlaysFull.put(Direction.NORTH, event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/full_drawers_lock"), (IModelTransform)ModelRotation.X0_Y0, ModelLoader.defaultTextureGetter()));
            lockOverlaysFull.put(Direction.EAST, event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/full_drawers_lock"), (IModelTransform)ModelRotation.X0_Y90, ModelLoader.defaultTextureGetter()));
            lockOverlaysFull.put(Direction.SOUTH, event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/full_drawers_lock"), (IModelTransform)ModelRotation.X0_Y180, ModelLoader.defaultTextureGetter()));
            lockOverlaysFull.put(Direction.WEST, event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/full_drawers_lock"), (IModelTransform)ModelRotation.X0_Y270, ModelLoader.defaultTextureGetter()));
            lockOverlaysHalf.put(Direction.NORTH, event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/half_drawers_lock"), (IModelTransform)ModelRotation.X0_Y0, ModelLoader.defaultTextureGetter()));
            lockOverlaysHalf.put(Direction.EAST, event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/half_drawers_lock"), (IModelTransform)ModelRotation.X0_Y90, ModelLoader.defaultTextureGetter()));
            lockOverlaysHalf.put(Direction.SOUTH, event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/half_drawers_lock"), (IModelTransform)ModelRotation.X0_Y180, ModelLoader.defaultTextureGetter()));
            lockOverlaysHalf.put(Direction.WEST, event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/half_drawers_lock"), (IModelTransform)ModelRotation.X0_Y270, ModelLoader.defaultTextureGetter()));
            Register.replaceBlock(event, ModBlocks.OAK_FULL_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.OAK_FULL_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.OAK_FULL_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.OAK_HALF_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.OAK_HALF_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.OAK_HALF_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.SPRUCE_FULL_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.SPRUCE_FULL_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.SPRUCE_FULL_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.SPRUCE_HALF_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.SPRUCE_HALF_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.SPRUCE_HALF_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.BIRCH_FULL_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.BIRCH_FULL_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.BIRCH_FULL_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.BIRCH_HALF_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.BIRCH_HALF_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.BIRCH_HALF_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.JUNGLE_FULL_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.JUNGLE_FULL_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.JUNGLE_FULL_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.JUNGLE_HALF_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.JUNGLE_HALF_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.JUNGLE_HALF_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.ACACIA_FULL_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.ACACIA_FULL_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.ACACIA_FULL_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.ACACIA_HALF_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.ACACIA_HALF_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.ACACIA_HALF_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.DARK_OAK_FULL_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.DARK_OAK_FULL_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.DARK_OAK_FULL_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.DARK_OAK_HALF_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.DARK_OAK_HALF_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.DARK_OAK_HALF_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.COMPACTING_DRAWERS_3);
            event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/full_drawers_lock"), (IModelTransform)ModelRotation.X0_Y0, ModelLoader.defaultTextureGetter());
        }

        public static void replaceBlock(ModelBakeEvent event, BlockDrawers block) {
            for (BlockState state : block.func_176194_O().func_177619_a()) {
                ModelResourceLocation modelResource = BlockModelShapes.func_209554_c((BlockState)state);
                IBakedModel parentModel = event.getModelManager().func_174953_a(modelResource);
                if (parentModel == event.getModelManager().func_174951_a()) continue;
                if (block.isHalfDepth()) {
                    event.getModelRegistry().put(modelResource, new Model2.HalfModel(parentModel));
                    continue;
                }
                event.getModelRegistry().put(modelResource, new Model2.FullModel(parentModel));
            }
        }
    }
}

