/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.capabilities;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import java.util.EnumSet;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;

public class BasicDrawerAttributes
implements IDrawerAttributes,
IDrawerAttributesModifiable,
INBTSerializable<CompoundNBT> {
    private EnumSet<LockAttribute> itemLock = EnumSet.noneOf(LockAttribute.class);
    private boolean isConcealed;
    private boolean isShowingQuantity;
    private boolean isVoid;
    private boolean isUnlimitedStorage;
    private boolean isUnlimitedVending;
    private boolean isConversion;

    @Override
    public boolean canItemLock(LockAttribute attr) {
        return true;
    }

    @Override
    public boolean isItemLocked(LockAttribute attr) {
        return this.itemLock.contains((Object)attr);
    }

    @Override
    public boolean setItemLocked(LockAttribute attr, boolean isLocked) {
        if (this.isItemLocked(attr) != isLocked) {
            if (isLocked) {
                this.itemLock.add(attr);
            } else {
                this.itemLock.remove((Object)attr);
            }
            this.onAttributeChanged();
        }
        return true;
    }

    @Override
    public boolean isConcealed() {
        return this.isConcealed;
    }

    @Override
    public boolean setIsConcealed(boolean state) {
        if (this.isConcealed != state) {
            this.isConcealed = state;
            this.onAttributeChanged();
        }
        return true;
    }

    @Override
    public boolean isVoid() {
        return this.isVoid;
    }

    @Override
    public boolean setIsVoid(boolean state) {
        if (this.isVoid != state) {
            this.isVoid = state;
            this.onAttributeChanged();
        }
        return true;
    }

    @Override
    public boolean isShowingQuantity() {
        return this.isShowingQuantity;
    }

    @Override
    public boolean setIsShowingQuantity(boolean state) {
        if (this.isShowingQuantity != state) {
            this.isShowingQuantity = state;
            this.onAttributeChanged();
        }
        return true;
    }

    @Override
    public boolean isUnlimitedStorage() {
        return this.isUnlimitedStorage;
    }

    @Override
    public boolean setIsUnlimitedStorage(boolean state) {
        if (this.isUnlimitedStorage != state) {
            this.isUnlimitedStorage = state;
            this.onAttributeChanged();
        }
        return true;
    }

    @Override
    public boolean isUnlimitedVending() {
        return this.isUnlimitedVending;
    }

    @Override
    public boolean setIsUnlimitedVending(boolean state) {
        if (this.isUnlimitedVending != state) {
            this.isUnlimitedVending = state;
            this.onAttributeChanged();
        }
        return true;
    }

    @Override
    public boolean isDictConvertible() {
        return this.isConversion;
    }

    @Override
    public boolean setIsDictConvertible(boolean state) {
        if (this.isConversion != state) {
            this.isConversion = state;
            this.onAttributeChanged();
        }
        return true;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("itemLock", LockAttribute.getBitfield(this.itemLock));
        tag.func_74757_a("concealed", this.isConcealed);
        tag.func_74757_a("void", this.isVoid);
        tag.func_74757_a("quant", this.isShowingQuantity);
        tag.func_74757_a("unlimited", this.isUnlimitedStorage);
        tag.func_74757_a("vending", this.isUnlimitedVending);
        tag.func_74757_a("conv", this.isConversion);
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.itemLock = LockAttribute.getEnumSet(nbt.func_74762_e("itemLock"));
        this.isConcealed = nbt.func_74767_n("concealed");
        this.isVoid = nbt.func_74767_n("void");
        this.isShowingQuantity = nbt.func_74767_n("quant");
        this.isUnlimitedStorage = nbt.func_74767_n("unlimited");
        this.isUnlimitedVending = nbt.func_74767_n("vending");
        this.isConversion = nbt.func_74767_n("conv");
    }

    protected void onAttributeChanged() {
    }
}

