/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import info.u_team.u_team_core.api.dye.IDyeableItem;
import info.u_team.u_team_core.recipeserializer.UShapedRecipeSerializer;
import info.u_team.u_team_core.util.ColorUtil;
import info.u_team.useful_backpacks.init.UsefulBackpacksRecipeSerializers;
import info.u_team.useful_backpacks.item.BackpackItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class BackpackCraftingRecipe
extends ShapedRecipe {
    public BackpackCraftingRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> ingredients, ItemStack output) {
        super(id, group, width, height, ingredients, output);
    }

    public ItemStack func_77572_b(CraftingInventory inventory) {
        ItemStack backpackItem = super.func_77572_b(inventory);
        ArrayList dyeList = Lists.newArrayList();
        boolean backpackPresent = false;
        for (int index = 0; index < inventory.func_70302_i_(); ++index) {
            DyeColor color2;
            ItemStack slotStack = inventory.func_70301_a(index);
            if (slotStack.func_190926_b()) continue;
            Item item = slotStack.func_77973_b();
            if (item instanceof BackpackItem) {
                if (backpackPresent) {
                    return ItemStack.field_190927_a;
                }
                backpackPresent = true;
                if (!slotStack.func_77942_o()) continue;
                backpackItem.func_77982_d(slotStack.func_77978_p().func_74737_b());
                continue;
            }
            if (!ItemTags.field_199904_a.func_199685_a_((Object)item) || (color2 = ColorUtil.getColorFromWool((Block)Block.func_149634_a((Item)item))) == null) continue;
            dyeList.add(color2);
        }
        if (!dyeList.isEmpty() && !dyeList.parallelStream().allMatch(color -> color == DyeColor.WHITE)) {
            return IDyeableItem.colorStack((ItemStack)backpackItem, (List)dyeList);
        }
        return backpackItem;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return UsefulBackpacksRecipeSerializers.BACKPACK;
    }

    public static class Serializer
    extends UShapedRecipeSerializer<BackpackCraftingRecipe> {
        public Serializer(String name) {
            super(name);
        }

        public BackpackCraftingRecipe read(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Map keys = Serializer.deserializeKey((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
            String[] pattern = Serializer.shrink((String[])Serializer.patternFromJson((JsonArray)JSONUtils.func_151214_t((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList ingredients = Serializer.deserializeIngredients((String[])pattern, (Map)keys, (int)width, (int)height);
            ItemStack output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new BackpackCraftingRecipe(recipeId, group, width, height, (NonNullList<Ingredient>)ingredients, output);
        }

        public BackpackCraftingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            int width = buffer.func_150792_a();
            int height = buffer.func_150792_a();
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            NonNullList ingredients = NonNullList.func_191197_a((int)(width * height), (Object)Ingredient.field_193370_a);
            for (int index = 0; index < ingredients.size(); ++index) {
                ingredients.set(index, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack output = buffer.func_150791_c();
            return new BackpackCraftingRecipe(recipeId, group, width, height, (NonNullList<Ingredient>)ingredients, output);
        }

        public void write(PacketBuffer buffer, BackpackCraftingRecipe recipe) {
            buffer.func_150787_b(recipe.func_192403_f());
            buffer.func_150787_b(recipe.func_192404_g());
            buffer.func_180714_a(recipe.func_193358_e());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.func_77571_b());
        }
    }
}

