/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.crafting.network;

import java.util.function.Supplier;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbase.modules.crafting.items.CraftingCardItem;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUpdateNBTItemCard {
    public TypedMap args;

    public PacketUpdateNBTItemCard() {
    }

    public PacketUpdateNBTItemCard(PacketBuffer buf) {
        this.args = TypedMapTools.readArguments((PacketBuffer)buf);
    }

    public PacketUpdateNBTItemCard(TypedMap arguments) {
        this.args = arguments;
    }

    protected boolean isValidItem(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof CraftingCardItem;
    }

    public void toBytes(PacketBuffer buf) {
        TypedMapTools.writeArguments((PacketBuffer)buf, (TypedMap)this.args);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity playerEntity = ctx.getSender();
            ItemStack heldItem = playerEntity.func_184586_b(Hand.MAIN_HAND);
            if (heldItem.func_190926_b()) {
                return;
            }
            if (!this.isValidItem(heldItem)) {
                return;
            }
            CompoundNBT tagCompound = heldItem.func_196082_o();
            for (Key akey : this.args.getKeys()) {
                String key = akey.getName();
                if (Type.STRING.equals(akey.getType())) {
                    tagCompound.func_74778_a(key, (String)this.args.get(akey));
                    continue;
                }
                if (Type.INTEGER.equals(akey.getType())) {
                    tagCompound.func_74768_a(key, ((Integer)this.args.get(akey)).intValue());
                    continue;
                }
                if (Type.LONG.equals(akey.getType())) {
                    tagCompound.func_74772_a(key, ((Long)this.args.get(akey)).longValue());
                    continue;
                }
                if (Type.DOUBLE.equals(akey.getType())) {
                    tagCompound.func_74780_a(key, ((Double)this.args.get(akey)).doubleValue());
                    continue;
                }
                if (Type.BOOLEAN.equals(akey.getType())) {
                    tagCompound.func_74757_a(key, ((Boolean)this.args.get(akey)).booleanValue());
                    continue;
                }
                if (Type.BLOCKPOS.equals(akey.getType())) {
                    throw new RuntimeException("BlockPos not supported for PacketUpdateNBTItem!");
                }
                if (Type.ITEMSTACK.equals(akey.getType())) {
                    throw new RuntimeException("ItemStack not supported for PacketUpdateNBTItem!");
                }
                throw new RuntimeException(akey.getType().getType().getSimpleName() + " not supported for PacketUpdateNBTItem!");
            }
        });
        ctx.setPacketHandled(true);
    }
}

