/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.util;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import stepsword.mahoutsukai.capability.caliburn.CaliburnMahouProvider;
import stepsword.mahoutsukai.capability.caliburn.ICaliburnMahou;
import stepsword.mahoutsukai.capability.containers.MysticCodeInventoryProvider;
import stepsword.mahoutsukai.capability.gemmahou.GemMahouProvider;
import stepsword.mahoutsukai.capability.gemmahou.IGemMahou;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.MahouProvider;
import stepsword.mahoutsukai.capability.scrollmahou.IScrollMahou;
import stepsword.mahoutsukai.capability.scrollmahou.ScrollMahouProvider;
import stepsword.mahoutsukai.capability.worldsave.IWorldMahou;
import stepsword.mahoutsukai.capability.worldsave.WorldMahouProvider;
import stepsword.mahoutsukai.fluids.ModFluids;

public class Utils {
    public static IMahou getPlayerMahou(LivingEntity player) {
        try {
            LazyOptional lazy = player.getCapability(MahouProvider.MAHOU, null);
            return (IMahou)lazy.orElseThrow(() -> new RuntimeException());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IItemHandler getInventory(ItemStack stack) {
        try {
            LazyOptional lazy = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return (IItemHandler)lazy.orElseThrow(() -> new RuntimeException());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IItemHandler getInventory(LivingEntity e) {
        try {
            LazyOptional lazy = e.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return (IItemHandler)lazy.orElseThrow(() -> new RuntimeException());
        }
        catch (Exception xe) {
            return null;
        }
    }

    public static IItemHandler getMCInventory(ItemStack stack) {
        try {
            LazyOptional lazy = stack.getCapability(MysticCodeInventoryProvider.MYSTIC_CODE_INVENTORY, null);
            return (IItemHandler)lazy.orElseThrow(() -> new RuntimeException());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IItemHandler getInventory(TileEntity stack) {
        try {
            LazyOptional lazy = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return (IItemHandler)lazy.orElseThrow(() -> new RuntimeException());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IGemMahou getGemMahou(ItemStack stack) {
        try {
            LazyOptional lazy = stack.getCapability(GemMahouProvider.MAHOU, null);
            return (IGemMahou)lazy.orElseThrow(() -> new RuntimeException());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IScrollMahou getScrollMahou(ItemStack stack) {
        try {
            LazyOptional lazy = stack.getCapability(ScrollMahouProvider.MAHOU, null);
            return (IScrollMahou)lazy.orElseThrow(() -> new RuntimeException());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ICaliburnMahou getCaliburnMahou(ItemStack stack) {
        try {
            LazyOptional lazy = stack.getCapability(CaliburnMahouProvider.MAHOU, null);
            return (ICaliburnMahou)lazy.orElseThrow(() -> new RuntimeException());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IWorldMahou getWorldMahou(World world) {
        try {
            LazyOptional lazy = world.getCapability(WorldMahouProvider.MAHOU, null);
            return (IWorldMahou)lazy.orElseThrow(() -> new RuntimeException());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isBlockAir(World world, BlockPos pos) {
        Block b = world.func_180495_p(pos).func_177230_c();
        return b.isAir(world.func_180495_p(pos), (IBlockReader)world, pos) || b == Blocks.field_150350_a || b == Blocks.field_201941_jj || b == Blocks.field_201940_ji;
    }

    public static RayTraceResult rayTraceEyes(LivingEntity entity, double length) {
        Vec3d startPos = new Vec3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_());
        Vec3d endPos = startPos.func_178787_e(new Vec3d(entity.func_70040_Z().field_72450_a * length, entity.func_70040_Z().field_72448_b * length, entity.func_70040_Z().field_72449_c * length));
        return entity.field_70170_p.func_217299_a(new RayTraceContext(startPos, endPos, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)entity));
    }

    public static boolean isInMurkyWater(Entity entity) {
        double eyes = entity.func_226278_cu_() + (double)entity.func_70047_e();
        BlockState state = entity.field_70170_p.func_180495_p(new BlockPos(entity.func_174824_e(1.0f)));
        Block block = state.func_177230_c();
        double filled = 0.0;
        if (block instanceof FlowingFluidBlock && (((FlowingFluidBlock)block).getFluid() == ModFluids.MURKY_FLOW || ((FlowingFluidBlock)block).getFluid() == ModFluids.MURKY_STILL)) {
            double h;
            filled = h = (double)((FlowingFluidBlock)block).func_204507_t(state).func_223408_f() + 0.1111111111111111;
        }
        return eyes - Math.floor(eyes) < filled;
    }
}

