/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.displacement;

import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.common.DimensionManager;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;

public class EquivalentDisplacementMahoujinTileEntity
extends MahoujinTileEntity
implements ITickableTileEntity {
    TicketType<ChunkPos> ticket = null;
    private int receivingTickCounter = 0;
    private int tickCounter = 0;
    private BlockPos targetLocation = null;
    private DimensionType targetDimension = null;
    public static String TELEPORTER_BOUND_TAG_X = "MAHOUTSUKAI_BOUND_TELEPORTER_TAG_X";
    public static String TELEPORTER_BOUND_TAG_Y = "MAHOUTSUKAI_BOUND_TELEPORTER_TAG_Y";
    public static String TELEPORTER_BOUND_TAG_Z = "MAHOUTSUKAI_BOUND_TELEPORTER_TAG_Z";
    public static String TELEPORTER_BOUND_TAG_D = "MAHOUTSUKAI_BOUND_TELEPORTER_TAG_D";

    public EquivalentDisplacementMahoujinTileEntity() {
        super((TileEntityType)ModTileEntities.equivalentDisplacement);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.targetLocation != null) {
            compound.func_74768_a(TELEPORTER_BOUND_TAG_X, this.targetLocation.func_177958_n());
            compound.func_74768_a(TELEPORTER_BOUND_TAG_Y, this.targetLocation.func_177956_o());
            compound.func_74768_a(TELEPORTER_BOUND_TAG_Z, this.targetLocation.func_177952_p());
        }
        if (this.targetDimension != null && this.targetDimension.getRegistryName() != null) {
            compound.func_74778_a(TELEPORTER_BOUND_TAG_D, this.targetDimension.getRegistryName().toString());
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        if (compound.func_74764_b(TELEPORTER_BOUND_TAG_X) && compound.func_74764_b(TELEPORTER_BOUND_TAG_Y) && compound.func_74764_b(TELEPORTER_BOUND_TAG_Z)) {
            int x = compound.func_74762_e(TELEPORTER_BOUND_TAG_X);
            int y = compound.func_74762_e(TELEPORTER_BOUND_TAG_Y);
            int z = compound.func_74762_e(TELEPORTER_BOUND_TAG_Z);
            this.targetLocation = new BlockPos(x, y, z);
        }
        this.targetDimension = compound.func_74764_b(TELEPORTER_BOUND_TAG_D) ? DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(compound.func_74779_i(TELEPORTER_BOUND_TAG_D))) : DimensionType.field_223227_a_;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.loadChunks();
        }
        super.func_145839_a(compound);
    }

    public BlockPos getTargetLocation() {
        return this.targetLocation;
    }

    public DimensionType getTargetDimension() {
        return this.targetDimension;
    }

    public void setTargetLocation(BlockPos pos) {
        this.targetLocation = pos;
    }

    public void setTargetDimension(DimensionType d) {
        this.targetDimension = d;
    }

    public DimensionType getDimension() {
        return this.field_145850_b.field_73011_w.func_186058_p();
    }

    public void setReceivingTickCounter(int t) {
        this.receivingTickCounter = t;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.receivingTickCounter <= 0) {
                if (this.tickCounter == MTConfig.EQUIVALENT_DISPLACEMENT_BLOCK_CYCLE) {
                    EquivalentDisplacementMahoujinTileEntity tte;
                    BlockPos target = this.getTargetLocation();
                    DimensionType d = this.getDimension();
                    if (target != null && (!target.equals((Object)this.field_174879_c) || d != this.targetDimension) && EquivalentDisplacementMahoujinTileEntity.doITeleport(this.field_174879_c, target, d, this.targetDimension) && (tte = this.getTargetTE(target, this.targetDimension)) != null && tte.getCasterUUID().equals(this.getCasterUUID())) {
                        Entity here = this.entityReadyToTeleport();
                        Entity there = tte.entityReadyToTeleport();
                        if (here != null && there != null) {
                            PlayerEntity caster = this.getCaster();
                            boolean nearbyBatteriesGaveMana = PlayerManaManager.getManaFromBatteriesFirst(this.field_174879_c, this.field_145850_b, this.getCasterUUID(), MTConfig.EQUIVALENT_DISPLACEMENT_MANA_COST);
                            if (nearbyBatteriesGaveMana || caster != null && PlayerManaManager.drainMana(caster, MTConfig.EQUIVALENT_DISPLACEMENT_MANA_COST, false, false) == MTConfig.EQUIVALENT_DISPLACEMENT_MANA_COST) {
                                MahouTsukaiTeleporter.teleport(here, target.func_177958_n(), target.func_177956_o(), target.func_177952_p(), this.targetDimension);
                                MahouTsukaiTeleporter.teleport(there, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), d);
                                this.setReceivingTickCounter(MTConfig.EQUIVALENT_DISPLACEMENT_RECEIVE_COOLDOWN);
                                tte.setReceivingTickCounter(MTConfig.EQUIVALENT_DISPLACEMENT_RECEIVE_COOLDOWN);
                            }
                        }
                    }
                    this.tickCounter = 0;
                }
                ++this.tickCounter;
            } else {
                --this.receivingTickCounter;
            }
            this.loadChunks();
        }
    }

    public void loadChunks() {
        if (this.ticket == null && !this.field_145850_b.field_72995_K) {
            this.ticket = TicketType.func_219484_a((String)this.serializeTicket(), Comparator.comparingLong(ChunkPos::func_201841_a));
        } else if (this.ticket != null && !this.field_145850_b.field_72995_K) {
            ChunkPos pos = new ChunkPos(this.func_174877_v());
            ((ServerWorld)this.field_145850_b).func_72863_F().func_217228_a(this.ticket, pos, 1, (Object)pos);
        }
    }

    public void releaseChunks() {
        if (this.ticket != null && !this.field_145850_b.field_72995_K) {
            ((ServerWorld)this.field_145850_b).func_72863_F().func_217222_b(this.ticket, new ChunkPos(this.func_174877_v()), 11, (Object)new ChunkPos(this.field_174879_c));
        }
    }

    public String serializeTicket() {
        String ret = "mahoutsukai_";
        ret = ret + this.field_174879_c.func_177958_n() + "_" + this.field_174879_c.func_177956_o() + "_" + this.field_174879_c.func_177952_p() + "_";
        ret = this.getDimension().getRegistryName() != null ? ret + this.getDimension().getRegistryName().toString() : ret + "overworld";
        return ret;
    }

    public static boolean doITeleport(BlockPos me, BlockPos target, DimensionType md, DimensionType td) {
        if (me.func_177958_n() != target.func_177958_n()) {
            return me.func_177958_n() < target.func_177958_n();
        }
        if (me.func_177956_o() != target.func_177956_o()) {
            return me.func_177956_o() < target.func_177956_o();
        }
        if (me.func_177952_p() != target.func_177952_p()) {
            return me.func_177952_p() < target.func_177952_p();
        }
        return md.hashCode() < td.hashCode();
    }

    public Entity entityReadyToTeleport() {
        List lst = this.field_145850_b.func_217357_a(Entity.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)));
        if (lst.isEmpty()) {
            return null;
        }
        return (Entity)lst.get(0);
    }

    public EquivalentDisplacementMahoujinTileEntity getTargetTE(BlockPos pos, DimensionType dimension) {
        TileEntity te;
        ServerWorld worldServer = DimensionManager.getWorld((MinecraftServer)this.field_145850_b.func_73046_m(), (DimensionType)dimension, (boolean)false, (boolean)true);
        if (worldServer != null && (te = worldServer.func_175625_s(pos)) instanceof EquivalentDisplacementMahoujinTileEntity) {
            return (EquivalentDisplacementMahoujinTileEntity)te;
        }
        return null;
    }
}

