/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.boundary;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.block.spells.boundary.InvisibleBarrierBlock;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.boundary.BoundaryMahoujinTileEntity;
import stepsword.mahoutsukai.tile.boundary.InvisibleBarrierBlockTileEntity;

public class TangibleBoundaryMahoujinTileEntity
extends BoundaryMahoujinTileEntity {
    public TangibleBoundaryMahoujinTileEntity() {
        super((TileEntityType)ModTileEntities.tangibleBoundary);
    }

    @Override
    public int getManaCost() {
        return MTConfig.TANGIBLE_BARRIER_MANA_COST;
    }

    @Override
    public int getManaCycle() {
        return MTConfig.TANGIBLE_BARRIER_MANA_CYCLE;
    }

    @Override
    public int getBarrierCycle() {
        return MTConfig.TANGIBLE_BARRIER_CYCLE;
    }

    @Override
    public int getBarrierRadius() {
        return MTConfig.TANGIBLE_BARRIER_RADIUS;
    }

    @Override
    public void doBarrier(List<LivingEntity> entities) {
        Stream<BlockPos> box = TangibleBoundaryMahoujinTileEntity.getBox(this.field_174879_c, this.getBarrierRadius());
        this.placeAllBarriers(box);
    }

    public static Stream<BlockPos> getBox(BlockPos pos, int radius) {
        return BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-radius, -radius, -radius), (BlockPos)pos.func_177982_a(radius, radius, radius));
    }

    public static void removeAllBarriers(Stream<BlockPos> box, World world) {
        box.forEach(tmp -> {
            if (world.func_180495_p(tmp).func_177230_c() instanceof InvisibleBarrierBlock) {
                world.func_175656_a(tmp, Blocks.field_150350_a.func_176223_P());
            }
        });
    }

    @Override
    public void doNotBarrier() {
        Stream<BlockPos> box = TangibleBoundaryMahoujinTileEntity.getBox(this.field_174879_c, this.getBarrierRadius());
        TangibleBoundaryMahoujinTileEntity.removeAllBarriers(box, this.field_145850_b);
    }

    public void placeAllBarriers(Stream<BlockPos> box) {
        box.forEach(tmp -> {
            Block b;
            if ((tmp.func_177958_n() == this.field_174879_c.func_177958_n() - this.getBarrierRadius() || tmp.func_177958_n() == this.field_174879_c.func_177958_n() + this.getBarrierRadius() || tmp.func_177956_o() == this.field_174879_c.func_177956_o() - this.getBarrierRadius() || tmp.func_177956_o() == this.field_174879_c.func_177956_o() + this.getBarrierRadius() || tmp.func_177952_p() == this.field_174879_c.func_177952_p() - this.getBarrierRadius() || tmp.func_177952_p() == this.field_174879_c.func_177952_p() + this.getBarrierRadius()) && ((b = this.field_145850_b.func_180495_p(tmp).func_177230_c()) instanceof AirBlock || b instanceof TallGrassBlock || b instanceof FlowerBlock)) {
                this.field_145850_b.func_175656_a(tmp, ModBlocks.invisibleBarrierBlock.func_176223_P());
                TileEntity te = this.field_145850_b.func_175625_s(tmp);
                if (te != null) {
                    ((InvisibleBarrierBlockTileEntity)te).setCasterUUID(this.getCasterUUID());
                    ((InvisibleBarrierBlockTileEntity)te).setBoundaryCircle(this.field_174879_c);
                }
            }
        });
    }

    @Override
    public ItemStack getItemToGive() {
        return new ItemStack((IItemProvider)ModItems.boundaryTangibleScroll);
    }
}

