/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.boundary;

import java.util.stream.Stream;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.SingleUseMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class RaiseEnclosureBarrierMahoujinTileEntity
extends SingleUseMahoujinTileEntity
implements ITickableTileEntity {
    public static final String RAISED = "MAHOUTSUKAI_NUM_TIMES_RAISED";
    private int numTimesRaised = 0;
    private int tickCounter = 0;

    public RaiseEnclosureBarrierMahoujinTileEntity() {
        super((TileEntityType)ModTileEntities.raiseEnclosureBoundary);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a(RAISED, this.numTimesRaised);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.numTimesRaised = compound.func_74762_e(RAISED);
        super.func_145839_a(compound);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.tickCounter == MTConfig.ENCLOSURE_BARRIER_CYCLE) {
                if (this.numTimesRaised >= MTConfig.ENCLOSURE_BARRIER_RADIUS - 1) {
                    EffectUtil.tryChangeBlockState(false, this.field_174879_c, Blocks.field_150350_a.func_176223_P(), this.field_145850_b, this.getCaster());
                } else {
                    boolean nearbyBatteriesGaveMana = PlayerManaManager.getManaFromBatteriesFirst(this.field_174879_c, this.field_145850_b, this.getCasterUUID(), MTConfig.ENCLOSURE_BARRIER_MANA_COST);
                    if (nearbyBatteriesGaveMana || this.getCaster() != null && PlayerManaManager.drainMana(this.getCaster(), MTConfig.ENCLOSURE_BARRIER_MANA_COST, false, true) == MTConfig.ENCLOSURE_BARRIER_MANA_COST) {
                        this.raiseEnclosure();
                        ++this.numTimesRaised;
                    }
                }
                this.tickCounter = 0;
            }
            ++this.tickCounter;
        }
    }

    public void raiseEnclosure() {
        int bottom = MTConfig.ENCLOSURE_BARRIER_RADIUS - this.numTimesRaised - 1;
        Stream box = BlockPos.func_218281_b((BlockPos)this.field_174879_c.func_177982_a(-MTConfig.ENCLOSURE_BARRIER_RADIUS, -bottom, -MTConfig.ENCLOSURE_BARRIER_RADIUS), (BlockPos)this.field_174879_c.func_177982_a(MTConfig.ENCLOSURE_BARRIER_RADIUS, -bottom, MTConfig.ENCLOSURE_BARRIER_RADIUS));
        box.forEach(tmp -> {
            int k;
            if (tmp.func_177956_o() == this.field_174879_c.func_177956_o() - bottom && (tmp.func_177958_n() == this.field_174879_c.func_177958_n() - MTConfig.ENCLOSURE_BARRIER_RADIUS || tmp.func_177958_n() == this.field_174879_c.func_177958_n() + MTConfig.ENCLOSURE_BARRIER_RADIUS || tmp.func_177952_p() == this.field_174879_c.func_177952_p() - MTConfig.ENCLOSURE_BARRIER_RADIUS || tmp.func_177952_p() == this.field_174879_c.func_177952_p() + MTConfig.ENCLOSURE_BARRIER_RADIUS) && (k = this.checkValidColumn((BlockPos)tmp)) > 0) {
                for (int i = k; i > 0; --i) {
                    BlockPos p = tmp.func_177982_a(0, i, 0);
                    EffectUtil.tryChangeBlockState(false, p, this.field_145850_b.func_180495_p(p.func_177982_a(0, -1, 0)), this.field_145850_b, this.getCaster());
                }
                EffectUtil.tryChangeBlockState(false, tmp, Blocks.field_150350_a.func_176223_P(), this.field_145850_b, this.getCaster());
            }
        });
    }

    public int checkValidColumn(BlockPos p) {
        boolean numAir = false;
        for (int k = 0; k < 255 - p.func_177956_o() - 1; ++k) {
            if (Utils.isBlockAir(this.field_145850_b, p.func_177982_a(0, k, 0)) && k >= MTConfig.ENCLOSURE_BARRIER_RADIUS - 1) {
                return k;
            }
            if (this.field_145850_b.func_175625_s(p.func_177982_a(0, k, 0)) != null) {
                return -1;
            }
            if (this.field_145850_b.func_180495_p(p.func_177982_a(0, k, 0)).func_177230_c() != Blocks.field_150357_h) continue;
            return -1;
        }
        return -1;
    }

    @Override
    public ItemStack getItemToGive() {
        return new ItemStack((IItemProvider)ModItems.boundaryRaiseEnclosureScroll);
    }
}

