/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.QuadTransformer;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import stepsword.mahoutsukai.item.spells.projection.WeaponProjectile.WeaponProjectileBow;

public class WeaponProjectileBowModel
implements IModelGeometry<WeaponProjectileBowModel> {
    public static ResourceLocation standby = new ResourceLocation("mahoutsukai", "item/weapon_projectile_bow_standby");
    public static ResourceLocation pulling0 = new ResourceLocation("mahoutsukai", "item/weapon_projectile_bow_pulling_0");
    public static ResourceLocation pulling1 = new ResourceLocation("mahoutsukai", "item/weapon_projectile_bow_pulling_1");
    public static ResourceLocation pulling2 = new ResourceLocation("mahoutsukai", "item/weapon_projectile_bow_pulling_2");
    private final ResourceLocation bowTexture;
    private final ResourceLocation projectileTexture;
    private final String ammo;
    private final int pulling;

    public WeaponProjectileBowModel(ResourceLocation bt, ResourceLocation pt, String ammo, int pull) {
        this.bowTexture = bt;
        this.projectileTexture = pt;
        this.ammo = ammo;
        this.pulling = pull;
    }

    public Collection<? extends IModelGeometryPart> getParts() {
        return null;
    }

    public Optional<? extends IModelGeometryPart> getPart(String name) {
        return Optional.empty();
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite particleSprite;
        ImmutableMap transformMap;
        TransformationMatrix transform;
        ImmutableList.Builder builder;
        block16: {
            builder = ImmutableList.builder();
            if (this.bowTexture != null) {
                IBakedModel ibakedmodel = Minecraft.func_71410_x().func_209506_al().getModel(this.bowTexture);
                builder.addAll((Iterable)ibakedmodel.getQuads(null, null, new Random(), null));
            }
            modelTransform = new ModelTransformComposition(modelTransform, (IModelTransform)new SimpleModelTransform(new TransformationMatrix(null, new Quaternion(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
            transform = modelTransform.func_225615_b_();
            IModelTransform transformsFromModel = owner.getCombinedTransform();
            ImmutableMap immutableMap = transformMap = transformsFromModel != null ? PerspectiveMapWrapper.getTransforms((IModelTransform)new ModelTransformComposition(transformsFromModel, modelTransform)) : PerspectiveMapWrapper.getTransforms((IModelTransform)modelTransform);
            if (this.ammo != null && this.pulling >= 0) {
                float tx = 0.0f;
                float tz = 0.0f;
                if (this.pulling == 0) {
                    tx = 3.0f;
                    tz = 3.0f;
                } else if (this.pulling == 1) {
                    tx = 2.0f;
                    tz = 2.0f;
                } else if (this.pulling == 2) {
                    tx = 1.0f;
                    tz = 1.0f;
                }
                transform = new TransformationMatrix(new Vector3f(-tx / 16.0f + 1.0f, tz / 16.0f, 0.0f), new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), 90.0f, true), new Vector3f(1.01f, 1.01f, 1.01f), null);
                transform.blockCenterToCorner();
            }
            particleSprite = this.bowTexture != null ? spriteGetter.apply(owner.resolveTexture(this.bowTexture.toString())) : null;
            try {
                if (this.ammo == null || this.ammo.equals("")) break block16;
                ItemStack ammostack = ItemStack.func_199557_a((CompoundNBT)JsonToNBT.func_180713_a((String)this.ammo));
                ResourceLocation pt = this.projectileTexture;
                ModelResourceLocation mpt = ModelLoader.getInventoryVariant((String)ammostack.func_77973_b().getRegistryName().toString());
                if (pt == null) {
                    IBakedModel m = Minecraft.func_71410_x().func_209506_al().getModel((ResourceLocation)mpt);
                    IBakedModel bm = Minecraft.func_71410_x().func_175599_af().func_184393_a(new ItemStack((IItemProvider)Items.field_151040_l), null, null);
                    TextureAtlasSprite stackIcon = bm.func_177554_e();
                    pt = stackIcon.func_195668_m();
                }
                IBakedModel ammoModel = Minecraft.func_71410_x().func_175599_af().func_184393_a(ammostack, null, null);
                try {
                    if (ammoModel.func_200117_a(null, null, new Random()).size() <= 0) {
                        ammoModel = new ItemLayerModel(ImmutableList.of((Object)new Material(AtlasTexture.field_215262_g, pt))).bake(owner, bakery, spriteGetter, modelTransform, overrides, modelLocation);
                    }
                }
                catch (Exception e2) {
                    try {
                        if (ammoModel.func_200117_a(null, null, new Random()).size() <= 0) {
                            ammoModel = new ItemLayerModel(ImmutableList.of((Object)new Material(AtlasTexture.field_110575_b, pt))).bake(owner, bakery, spriteGetter, modelTransform, overrides, modelLocation);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                QuadTransformer qt = new QuadTransformer(transform);
                builder.addAll((Iterable)qt.processMany(ammoModel.getQuads(null, null, new Random(), null)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new BakedWeaponProjectileBowModel(bakery, owner, this, (ImmutableList<BakedQuad>)builder.build(), particleSprite, (ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix>)Maps.immutableEnumMap((Map)transformMap), Maps.newHashMap(), transform.isIdentity(), modelTransform, owner.isSideLit());
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet texs = Sets.newHashSet();
        return texs;
    }

    private static final class BakedWeaponProjectileBowModel
    extends BakedItemModel {
        private final IModelConfiguration owner;
        private final WeaponProjectileBowModel parent;
        private final Map<String, IBakedModel> cache;
        private final IModelTransform originalTransform;
        private final boolean isSideLit;

        BakedWeaponProjectileBowModel(ModelBakery bakery, IModelConfiguration owner, WeaponProjectileBowModel parent, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> transforms, Map<String, IBakedModel> cache, boolean untransformed, IModelTransform originalTransform, boolean isSideLit) {
            super(quads, particle, transforms, (ItemOverrideList)new WeaponProjectileBowOverrideHandler(bakery), untransformed, isSideLit);
            this.owner = owner;
            this.parent = parent;
            this.cache = cache;
            this.originalTransform = originalTransform;
            this.isSideLit = isSideLit;
        }
    }

    private static final class WeaponProjectileBowOverrideHandler
    extends ItemOverrideList {
        private final ModelBakery bakery;

        private WeaponProjectileBowOverrideHandler(ModelBakery bakery) {
            this.bakery = bakery;
        }

        public IBakedModel func_209581_a(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
            float pull = 0.0f;
            BakedWeaponProjectileBowModel model = (BakedWeaponProjectileBowModel)originalModel;
            String ammoLoc = "";
            String ammoNBT = "";
            if (stack != null && stack.func_77973_b() instanceof WeaponProjectileBow && entity != null && entity.func_184607_cu().equals(stack)) {
                WeaponProjectileBow bow = (WeaponProjectileBow)stack.func_77973_b();
                ItemStack ammo = bow.getAmmoStack(stack);
                IItemPropertyGetter getter = bow.func_185045_a(new ResourceLocation("pull"));
                if (getter != null) {
                    pull = getter.call(stack, world, entity);
                }
                if (ammo != null && !ammo.func_190926_b()) {
                    CompoundNBT nbt;
                    TextureAtlasSprite stackIcon;
                    IBakedModel bm = Minecraft.func_71410_x().func_175599_af().func_184393_a(ammo, null, null);
                    if (bm != null && (stackIcon = bm.func_177554_e()) != null) {
                        ammoLoc = stackIcon.func_195668_m().toString();
                    }
                    if ((nbt = ammo.func_77955_b(new CompoundNBT())) != null) {
                        ammoNBT = nbt.toString();
                    }
                }
            }
            int pullState = -1;
            String tex = ":item/weapon_projectile_bow_standby";
            if (pull > 0.0f && pull < 0.7f) {
                pullState = 0;
                tex = ":item/weapon_projectile_bow_pulling_0";
            } else if (pull >= 0.7f && pull < 1.5f) {
                pullState = 1;
                tex = ":item/weapon_projectile_bow_pulling_1";
            } else if (pull >= 1.5f) {
                pullState = 2;
                tex = ":item/weapon_projectile_bow_pulling_2";
            }
            WeaponProjectileBowModel parent = new WeaponProjectileBowModel(new ResourceLocation("mahoutsukai" + tex), new ResourceLocation(ammoLoc), ammoNBT, pullState);
            IBakedModel bakedModel = parent.bake(model.owner, this.bakery, ModelLoader.defaultTextureGetter(), model.originalTransform, model.func_188617_f(), new ResourceLocation("mahoutsukai:weapon_projectile_bow"));
            return bakedModel;
        }
    }

    public static enum Loader implements IModelLoader<WeaponProjectileBowModel>
    {
        INSTANCE;


        public IResourceType getResourceType() {
            return VanillaResourceType.MODELS;
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        }

        public WeaponProjectileBowModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return new WeaponProjectileBowModel(null, null, null, 0);
        }
    }
}

