/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.MahouProvider;
import stepsword.mahoutsukai.networking.ClientPacketHandler;
import stepsword.mahoutsukai.util.ByteBufUtils;

public class PlayerMahouPacket {
    IMahou mahou;

    public PlayerMahouPacket() {
    }

    public PlayerMahouPacket(IMahou mahou) {
        this.mahou = mahou;
    }

    public void fromBytes(ByteBuf buf) {
        String s = ByteBufUtils.readUTF8String(buf);
        this.mahou = MahouProvider.stringToMahou(s);
    }

    public void toBytes(ByteBuf buf) {
        String s = MahouProvider.mahouToString(this.mahou);
        ByteBufUtils.writeUTF8String(buf, s);
    }

    public static void encode(PlayerMahouPacket msg, PacketBuffer buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static PlayerMahouPacket decode(PacketBuffer buf) {
        PlayerMahouPacket msg = new PlayerMahouPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(PlayerMahouPacket message, Supplier<NetworkEvent.Context> context) {
        ClientPacketHandler.mahouPacketHandler(message);
        context.get().setPacketHandled(true);
    }
}

