/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.EncoderException;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.networking.ClientPacketHandler;

public class DataManagerPacket {
    public BlockPos pos;
    public List<EntityDataManager.DataEntry<?>> dataManagerEntries;

    public DataManagerPacket() {
    }

    public DataManagerPacket(BlockPos pos, List<EntityDataManager.DataEntry<?>> dataManagerEntries) {
        this.pos = pos;
        this.dataManagerEntries = dataManagerEntries;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        PacketBuffer buffer = new PacketBuffer(buf);
        try {
            this.dataManagerEntries = EntityDataManager.func_187215_b((PacketBuffer)buffer);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        for (EntityDataManager.DataEntry<?> entry : this.dataManagerEntries) {
            DataParameter dataparameter = entry.func_187205_a();
            int i = DataSerializers.func_187188_b((IDataSerializer)dataparameter.func_187156_b());
            if (i < 0) {
                throw new EncoderException("Unknown serializer type " + dataparameter.func_187156_b());
            }
            buffer.writeByte(dataparameter.func_187155_a());
            buffer.func_150787_b(i);
            dataparameter.func_187156_b().func_187160_a(buffer, entry.func_187206_b());
        }
        buffer.writeByte(255);
    }

    public static void encode(DataManagerPacket msg, PacketBuffer buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static DataManagerPacket decode(PacketBuffer buf) {
        DataManagerPacket msg = new DataManagerPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(DataManagerPacket message, Supplier<NetworkEvent.Context> context) {
        ClientPacketHandler.updateTE(message);
        context.get().setPacketHandled(true);
    }
}

