/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.projection.PowerConsolidation;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import stepsword.mahoutsukai.capability.caliburn.CaliburnMahou;
import stepsword.mahoutsukai.capability.caliburn.CaliburnMahouProvider;
import stepsword.mahoutsukai.capability.caliburn.ICaliburnMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.render.item.CaliburnRenderer;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.FakeSkeleton;
import stepsword.mahoutsukai.util.Utils;

public class Caliburn
extends SwordItem {
    protected String name = "caliburn";
    public static String MT_ATTACK_DAMAGE = "mahoutsukai_caliburn_attack";

    public Caliburn() {
        super((IItemTier)ItemTier.IRON, 3, -2.4f, new Item.Properties().func_200916_a(ModItems.MAHOUTSUKAI_CREATIVE_TAB).func_200918_c(MTConfig.POWER_CONSOLIDATION_DURABILITY).setISTER(() -> CaliburnRenderer::new));
        this.setRegistryName(this.name);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        Caliburn.setattacktonbt(stack, worldIn);
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CaliburnMahouProvider();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT ret = super.getShareTag(stack);
        if (ret == null) {
            ICaliburnMahou mahou = Utils.getCaliburnMahou(stack);
            return (CompoundNBT)CaliburnMahouProvider.MAHOU.getStorage().writeNBT(CaliburnMahouProvider.MAHOU, (Object)mahou, null);
        }
        return ret;
    }

    public static void setattacktonbt(ItemStack stack, World world) {
        if (stack != null && !world.field_72995_K) {
            ICaliburnMahou mahou;
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new CompoundNBT();
            }
            if ((mahou = Utils.getCaliburnMahou(stack)) != null) {
                nbt.func_74776_a(MT_ATTACK_DAMAGE, mahou.getAttackDamage());
            }
            stack.func_77982_d(nbt);
        }
    }

    public static void getattackfromnbt(ItemStack stack) {
        ICaliburnMahou mahou;
        CompoundNBT nbt;
        if (stack != null && stack.func_77942_o() && (nbt = stack.func_77978_p()) != null && nbt.func_74764_b(MT_ATTACK_DAMAGE) && (mahou = Utils.getCaliburnMahou(stack)) != null) {
            mahou.setAttackDamage(Math.max(nbt.func_74760_g(MT_ATTACK_DAMAGE), mahou.getAttackDamage()));
        }
    }

    public void readShareTag(ItemStack stack, CompoundNBT nbtt) {
        if (nbtt != null) {
            ICaliburnMahou caliburnMahou = Utils.getCaliburnMahou(stack);
            CaliburnMahou serverCaliburnMahou = new CaliburnMahou();
            CaliburnMahouProvider.MAHOU.getStorage().readNBT(CaliburnMahouProvider.MAHOU, (Object)serverCaliburnMahou, null, (INBT)nbtt);
            if (caliburnMahou != null) {
                caliburnMahou.setAttackDamage(serverCaliburnMahou.getAttackDamage());
            }
        }
        super.readShareTag(stack, nbtt);
    }

    public static float simulateHit(ItemStack s, World world) {
        float ret = 3.0f;
        int health = 5000000;
        if (s != null) {
            ItemStack s1 = s.func_77946_l();
            FakeSkeleton fake_target = new FakeSkeleton(world);
            fake_target.h = 5000000.0f;
            FakePlayer fake_player = new FakePlayer((ServerWorld)world, new GameProfile(UUID.randomUUID(), "faker"));
            fake_player.func_184611_a(Hand.MAIN_HAND, s1);
            fake_player.func_110140_aT().func_111147_b(s1.func_111283_C(EquipmentSlotType.MAINHAND));
            try {
                ObfuscationReflectionHelper.setPrivateValue(LivingEntity.class, (Object)fake_player, (Object)1000, (String)"field_184617_aD");
            }
            catch (Exception e) {
                try {
                    ObfuscationReflectionHelper.setPrivateValue(LivingEntity.class, (Object)fake_player, (Object)1000, (String)"ticksSinceLastSwing");
                }
                catch (Exception e2) {
                    System.out.println(e2.toString());
                }
            }
            fake_player.func_71059_n((Entity)fake_target);
            ret = (float)health - fake_target.h;
        }
        return ret;
    }

    public static boolean specialTarget(LivingEntity entity) {
        return entity.func_70662_br() || Caliburn.containsKeyword(entity.func_200200_C_().func_150254_d().toLowerCase()) || Caliburn.containsKeyword(entity.func_145748_c_().toString().toLowerCase());
    }

    public static boolean containsKeyword(String name) {
        String[] arr = new String[]{"zomb", "vampir", "demon", "devil", "skele", "lich", "evil", "curse", "undead", "wither"};
        for (int i = 0; i < arr.length; ++i) {
            if (!name.contains(arr[i])) continue;
            return true;
        }
        int numKeys = arr.length;
        for (int i = 1; i < numKeys + 1; ++i) {
            if (!name.contains(new TranslationTextComponent("mahoutsukai.caliburnkeyword" + i, new Object[0]).func_150261_e())) continue;
            return true;
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand handIn) {
        if (player != null && !worldIn.field_72995_K) {
            int radius = MTConfig.POWER_CONSOLIDATION_PULL_RADIUS;
            AxisAlignedBB aabb = new AxisAlignedBB(player.func_180425_c().func_177982_a(-radius, -4, -radius), player.func_180425_c().func_177982_a(radius, 4, radius));
            List lst = worldIn.func_217357_a(LivingEntity.class, aabb);
            double score = -1.0;
            double chosendist = 0.0;
            LivingEntity chosen = null;
            for (LivingEntity target : lst) {
                if (target.func_110124_au().equals(player.func_110124_au()) || !EffectUtil.isLookingAtMe(target, (LivingEntity)player, 45) || !Caliburn.specialTarget(target)) continue;
                double d = Math.abs(EffectUtil.pointToLineDistance(target.func_174791_d(), player.func_174824_e(1.0f), player.func_70040_Z().func_178787_e(player.func_174824_e(1.0f))));
                double e = target.func_174791_d().func_72438_d(player.func_174791_d());
                if (score != -1.0 && !(score > d * d + e)) continue;
                score = d * d + e;
                chosen = target;
                chosendist = e;
            }
            if (chosen != null) {
                Vec3d chosenDirection = chosen.func_174791_d().func_178788_d(player.func_174791_d());
                Caliburn.boop((Entity)player, (float)(chosendist / 8.0), -chosenDirection.field_72450_a, -chosenDirection.field_72448_b, -chosenDirection.field_72449_c);
                Caliburn.boop(chosen, (float)(chosendist / 8.0), chosenDirection.field_72450_a, chosenDirection.field_72448_b, chosenDirection.field_72449_c);
            }
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(handIn));
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        float damage = 3.0f;
        Caliburn.getattackfromnbt(stack);
        if (slot == EquipmentSlotType.MAINHAND) {
            ICaliburnMahou mahou;
            if (stack != null && (mahou = Utils.getCaliburnMahou(stack)) != null) {
                damage = mahou.getAttackDamage();
            }
            multimap.removeAll((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
            multimap.removeAll((Object)SharedMonsterAttributes.field_188790_f.func_111108_a());
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)damage, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.600000095367432, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public static void boop(Entity entity, float strength, double x, double y, double z) {
        entity.field_70160_al = true;
        float f = MathHelper.func_76133_a((double)(x * x + z * z + y * y));
        double motionX = 0.0;
        double motionY = 0.0;
        double motionZ = 0.0;
        motionX -= x / (double)f * (double)strength;
        motionZ -= z / (double)f * (double)strength;
        motionY -= y / (double)f * (double)strength;
        entity.field_70133_I = true;
        if (entity.field_70122_E) {
            motionY /= 2.0;
            if ((motionY += 0.3) > 0.6) {
                motionY = 0.6;
            }
        }
        entity.func_213317_d(new Vec3d(motionX, motionY, motionZ));
    }
}

