/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.capability.scrollmahou.IScrollMahou;
import stepsword.mahoutsukai.capability.scrollmahou.ScrollMahou;
import stepsword.mahoutsukai.capability.scrollmahou.ScrollMahouProvider;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.FaeEssence;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.util.Utils;

public class SpellScroll
extends ItemBase {
    public SpellScroll(String name) {
        super("scroll_" + name);
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT ret = super.getShareTag(stack);
        if (ret == null) {
            IScrollMahou mahou = Utils.getScrollMahou(stack);
            return (CompoundNBT)ScrollMahouProvider.MAHOU.getStorage().writeNBT(ScrollMahouProvider.MAHOU, (Object)mahou, null);
        }
        return ret;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IScrollMahou scrollMahou;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        Item item = stack.func_77973_b();
        if (item instanceof SpellScroll && Utils.getScrollMahou(stack) != null && (scrollMahou = Utils.getScrollMahou(stack)) != null) {
            String name = scrollMahou.getCasterName();
            if (name != null && !name.isEmpty()) {
                tooltip.add((ITextComponent)new StringTextComponent("Bound to " + name));
            } else {
                tooltip.add((ITextComponent)new StringTextComponent("Bound to: ???"));
            }
        }
    }

    public void readShareTag(ItemStack stack, CompoundNBT nbtt) {
        IScrollMahou scrollMahou = Utils.getScrollMahou(stack);
        ScrollMahou serverScrollMahou = new ScrollMahou();
        if (nbtt != null) {
            ScrollMahouProvider.MAHOU.getStorage().readNBT(ScrollMahouProvider.MAHOU, (Object)serverScrollMahou, null, (INBT)nbtt);
            if (scrollMahou != null) {
                scrollMahou.setCasterUUID(serverScrollMahou.getCasterUUID());
                scrollMahou.setCasterName(serverScrollMahou.getCasterName());
            }
        }
        super.readShareTag(stack, nbtt);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ScrollMahouProvider();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        playerIn.func_184598_c(handIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        this.useAction(stack, worldIn, entityLiving, true);
    }

    public void useAction(ItemStack stack, World worldIn, LivingEntity entityLiving, boolean consume) {
        if (!worldIn.field_72995_K) {
            int cost = this.getInitialManaCost();
            IScrollMahou scrollMahou = this.getCapability(stack);
            if (entityLiving instanceof PlayerEntity && Utils.getPlayerMahou(entityLiving) != null) {
                PlayerEntity user = (PlayerEntity)entityLiving;
                if (scrollMahou != null && (user.func_110124_au().equals(scrollMahou.getCasterUUID()) || scrollMahou.getCasterUUID() == null || scrollMahou.getCasterUUID().equals(FaeEssence.faeID) || scrollMahou.getCasterUUID().equals(new UUID(0L, 0L)) || user.func_184812_l_()) && PlayerManaManager.drainMana(user, cost, false, false) == cost) {
                    if (this.shouldConsume(user, scrollMahou, consume)) {
                        stack.func_190918_g(1);
                    }
                    stack.func_77982_d((CompoundNBT)ScrollMahouProvider.MAHOU.getStorage().writeNBT(ScrollMahouProvider.MAHOU, (Object)scrollMahou, null));
                }
            }
        }
    }

    public boolean shouldConsume(PlayerEntity user, IScrollMahou scrollMahou, boolean consume) {
        return this.doSpell(user, scrollMahou) && (!user.func_184812_l_() || MTConfig.CREATIVE_MODE_SPELLS) && consume;
    }

    public IScrollMahou getCapability(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof SpellScroll) {
            return Utils.getScrollMahou(stack);
        }
        return null;
    }

    public int getInitialManaCost() {
        return 0;
    }

    public boolean doSpell(PlayerEntity user, IScrollMahou mahou) {
        return false;
    }
}

