/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.passive.ShoulderRidingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.fml.network.FMLPlayMessages;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.familiar.SummonFamiliarSpellEffect;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.networking.GardenPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.particle.ModParticles;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class FamiliarEntity
extends ShoulderRidingEntity
implements IFlyingAnimal {
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    public static final int exploreRadius = 5;
    private UUID familiarId = null;
    public int r;
    public int g;
    public int b;
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_GARDEN_TICKS = "MAHOUTSUKAI_GARDEN_TICKS";
    private static final String TAG_HOLIDAY = "MAHOUTSUKAI_HOLIDAY";
    private static final DataParameter<Float> COLOR_R = EntityDataManager.func_187226_a(FamiliarEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_G = EntityDataManager.func_187226_a(FamiliarEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_B = EntityDataManager.func_187226_a(FamiliarEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> HOLIDAY = EntityDataManager.func_187226_a(FamiliarEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> GARDEN_TICKS = EntityDataManager.func_187226_a(FamiliarEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final String entityName = "familiar_entity";
    TicketType<ChunkPos> ticket = null;
    BlockPos lastInteresting = null;

    public FamiliarEntity(World worldIn) {
        super(ModEntities.FAMILIAR, worldIn);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, false);
        this.func_110163_bv();
    }

    public FamiliarEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(ModEntities.FAMILIAR, worldIn);
    }

    public FamiliarEntity(EntityType entityEntityType, World world) {
        super(entityEntityType, world);
    }

    protected void func_184651_r() {
        this.field_70911_d = new SitGoal((TameableEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)this.field_70911_d);
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 5.0f, 1.0f, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 3.0f, 7.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)MTConfig.FAMILIAR_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a((double)0.4f);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, worldIn);
        flyingpathnavigator.func_192879_a(true);
        flyingpathnavigator.func_212239_d(true);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.6f;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.calculateFlapping();
        if (!this.field_70170_p.field_72995_K) {
            this.updateMap();
            this.loadChunks();
            this.reportSurroundings();
            this.gardenUpdate();
        }
    }

    public void activateGarden() {
        int gardenTime = 1200;
        this.setGardenTicks(gardenTime);
        this.acknowledge();
    }

    public void acknowledge() {
        if (this.func_70902_q() != null) {
            int z = this.func_70681_au().nextInt(4) + 1;
            TranslationTextComponent s = new TranslationTextComponent("mahoutsukai.acknowledge" + z, new Object[0]);
            this.func_70902_q().func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.AQUA + this.getMyName() + ": " + s.func_150261_e()));
        }
    }

    public void gardenUpdate() {
        float blue;
        float green;
        float red;
        int gardenTime = MTConfig.FAMILIARS_GARDEN_TIME;
        int tick = this.getGardenTicks();
        int startup = 20;
        float colorRatio = 1.0f;
        float gr = 232.0f;
        float gg = 86.0f;
        float gb = 186.0f;
        float nr = 91.0f;
        float ng = 209.0f;
        float nb = 252.0f;
        if (this.getHoliday()) {
            float[] fs = this.holidayToColor();
            nr = fs[0];
            ng = fs[1];
            nb = fs[2];
        }
        if (tick > 0) {
            if (tick < startup) {
                colorRatio = (float)tick / (float)startup;
            }
            if (tick > gardenTime - startup) {
                colorRatio = (float)(gardenTime - tick) / (float)startup;
            }
            red = (gr - nr) * colorRatio + nr;
            green = (gg - ng) * colorRatio + ng;
            blue = (gb - nb) * colorRatio + nb;
            if (tick % 100 == 0) {
                this.gardenEffectA();
            }
            this.setGardenTicks(tick - 1);
        } else {
            red = nr;
            green = ng;
            blue = nb;
        }
        if (tick < 0) {
            this.setGardenTicks(0);
        }
        this.setColor(red / 255.0f, green / 255.0f, blue / 255.0f);
    }

    public void gardenEffectA() {
        int range = MTConfig.FAMILIARS_GARDEN_RANGE;
        List nearby = this.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(this.func_226277_ct_() - (double)range, this.func_226278_cu_() - (double)range, this.func_226281_cx_() - (double)range, this.func_226277_ct_() + (double)range, this.func_226278_cu_() + (double)range, this.func_226281_cx_() + (double)range));
        for (PlayerEntity PlayerEntity2 : this.field_70170_p.func_217369_A()) {
            if (!(PlayerEntity2.func_195048_a(this.func_213303_ch()) < 16384.0)) continue;
            PacketHandler.sendTo((ServerPlayerEntity)PlayerEntity2, new GardenPacket(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()));
        }
        for (LivingEntity entity : nearby) {
            EffectUtil.buff(entity, ModEffects.PEACEFUL_GARDEN, false, 120);
        }
    }

    public static void gardenEffectB(BlockPos pos, World world) {
        int range = MTConfig.FAMILIARS_GARDEN_RANGE;
        Stream lst = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(range, range / 2, range), (BlockPos)pos.func_177982_a(-range, -range / 2, -range));
        lst.forEach(p -> {
            System.out.println(p);
            if (Utils.isBlockAir(world, pos)) {
                float x = p.func_177958_n();
                float y = p.func_177956_o();
                float z = p.func_177952_p();
                Random random = world.field_73012_v;
                double d = pos.func_177951_i((Vec3i)p);
                double rat = d / ((double)range * (double)range);
                if (rat > 1.0) {
                    rat = 1.0;
                }
                float lessenPetals = 0.4f;
                if (random != null) {
                    if (random.nextDouble() > rat && random.nextDouble() > (double)lessenPetals) {
                        world.func_195594_a((IParticleData)ModParticles.PETAL, (double)x + 0.2, (double)y + 0.2, (double)z + 0.2, 0.0, 0.0, 0.0);
                    }
                    if (random.nextDouble() > rat && random.nextDouble() > (double)lessenPetals) {
                        world.func_195594_a((IParticleData)ModParticles.PETAL, (double)x + 0.8, (double)y + 0.2, (double)z + 0.8, 0.0, 0.0, 0.0);
                    }
                    if (random.nextDouble() > rat && random.nextDouble() > (double)lessenPetals) {
                        world.func_195594_a((IParticleData)ModParticles.PETAL, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.0, 0.0, 0.0);
                    }
                    if (random.nextDouble() > rat && random.nextDouble() > (double)lessenPetals) {
                        world.func_195594_a((IParticleData)ModParticles.PETAL, (double)x + 0.2, (double)y + 0.8, (double)z + 0.8, 0.0, 0.0, 0.0);
                    }
                    if (random.nextDouble() > rat && random.nextDouble() > (double)lessenPetals) {
                        world.func_195594_a((IParticleData)ModParticles.PETAL, (double)x + 0.8, (double)y + 0.8, (double)z + 0.2, 0.0, 0.0, 0.0);
                    }
                }
            }
        });
    }

    public int getGardenTicks() {
        return (Integer)this.field_70180_af.func_187225_a(GARDEN_TICKS);
    }

    public void setGardenTicks(int t) {
        this.field_70180_af.func_187227_b(GARDEN_TICKS, (Object)t);
    }

    public void toggleHoliday() {
        this.setHoliday(!this.getHoliday());
    }

    public void setHoliday(boolean h) {
        this.field_70180_af.func_187227_b(HOLIDAY, (Object)h);
    }

    public boolean getHoliday() {
        return (Boolean)this.field_70180_af.func_187225_a(HOLIDAY);
    }

    public float[] holidayToColor() {
        float[] ret = new float[3];
        if (this.whichHoliday() == 1) {
            ret[0] = 51.0f;
            ret[1] = 204.0f;
            ret[2] = 51.0f;
        } else if (this.whichHoliday() == 2) {
            ret[0] = 140.0f;
            ret[1] = 0.0f;
            ret[2] = 255.0f;
        } else if (this.whichHoliday() == 3) {
            ret[0] = 23.0f;
            ret[1] = 209.0f;
            ret[2] = 54.0f;
        } else {
            ret[0] = 91.0f;
            ret[1] = 209.0f;
            ret[2] = 252.0f;
        }
        return ret;
    }

    public int whichHoliday() {
        if (Calendar.getInstance().get(2) == 11) {
            return 1;
        }
        if (Calendar.getInstance().get(2) == 1) {
            return 2;
        }
        if (Calendar.getInstance().get(2) == 2) {
            return 3;
        }
        return 0;
    }

    public void updateMap() {
        if (this.func_70902_q() != null) {
            if (SummonFamiliarSpellEffect.familiarMap.containsKey(this.func_184753_b())) {
                FamiliarEntity e = SummonFamiliarSpellEffect.familiarMap.get(this.func_184753_b());
                if (e != null && e.getFamiliarId() != null && e.getFamiliarId().equals(this.getFamiliarId())) {
                    if (!e.func_70089_S()) {
                        SummonFamiliarSpellEffect.familiarMap.put(this.func_184753_b(), this);
                    } else if (e != this) {
                        this.func_70106_y();
                    }
                } else {
                    this.func_70106_y();
                }
            } else {
                this.func_70106_y();
            }
        }
    }

    public void reportSurroundings() {
        PlayerEntity owner;
        if (this.field_70170_p.func_72820_D() % (long)MTConfig.FAMILIAR_REPORT_SURROUNDINGS_TIME == 0L && !this.field_70170_p.field_72995_K && (owner = (PlayerEntity)this.func_70902_q()) != null) {
            List players;
            AxisAlignedBB aabb = new AxisAlignedBB(this.func_180425_c().func_177982_a(-5, -5, -5), this.func_180425_c().func_177982_a(5, 5, 5));
            TranslationTextComponent toSend = null;
            Random rand = owner.func_70681_au();
            if (rand.nextBoolean() && !(players = this.field_70170_p.func_217357_a(PlayerEntity.class, aabb)).isEmpty()) {
                toSend = this.reportPlayer((PlayerEntity)players.get(rand.nextInt(players.size())), owner);
            }
            if (toSend == null) {
                List things;
                if (rand.nextBoolean() && !(things = this.field_70170_p.func_217357_a(LivingEntity.class, aabb)).isEmpty()) {
                    toSend = this.reportEntity((LivingEntity)things.get(rand.nextInt(things.size())), owner);
                }
                if (toSend == null && rand.nextBoolean()) {
                    ArrayList blocks = new ArrayList();
                    Stream lst = BlockPos.func_218287_a((int)((int)this.func_226277_ct_() - 5), (int)((int)this.func_226278_cu_() - 5), (int)((int)this.func_226281_cx_() - 5), (int)((int)this.func_226277_ct_() + 5), (int)((int)this.func_226278_cu_() + 5), (int)((int)this.func_226281_cx_() + 5));
                    lst.forEach(tmp -> {
                        BlockState bt = this.field_70170_p.func_180495_p(tmp);
                        if (this.isInterestingBlock(bt.func_177230_c())) {
                            blocks.add(new BlockPos(tmp.func_177958_n(), tmp.func_177956_o(), tmp.func_177952_p()));
                        }
                    });
                    if (!blocks.isEmpty()) {
                        IMahou mahou;
                        this.lastInteresting = (BlockPos)blocks.get(rand.nextInt(blocks.size()));
                        if (this.func_70902_q() != null && (mahou = Utils.getPlayerMahou(this.func_70902_q())) != null) {
                            mahou.setFamiliarInterestingBlock(this.lastInteresting);
                            EffectUtil.buff(this.func_70902_q(), ModEffects.INTERESTING_BLOCK, false, MTConfig.FAMILIAR_REPORT_SURROUNDINGS_TIME);
                            PlayerManaManager.updateClientMahou((ServerPlayerEntity)this.func_70902_q(), mahou);
                        }
                        toSend = this.reportBlock(this.field_70170_p.func_180495_p(this.lastInteresting).func_177230_c(), owner);
                    }
                }
            }
            if (toSend != null && !toSend.func_150254_d().equals("")) {
                owner.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.AQUA + this.getMyName() + ": " + toSend.func_150254_d()));
            }
        }
    }

    public String getMyName() {
        if (this.func_145818_k_()) {
            return this.func_200201_e().func_150261_e();
        }
        return "Familiar";
    }

    public boolean isInterestingBlock(Block b) {
        return b == Blocks.field_150482_ag || b == Blocks.field_150412_bA || b == Blocks.field_150369_x || b == Blocks.field_150342_X || b == Blocks.field_150343_Z || b == Blocks.field_180397_cI || b == Blocks.field_150352_o || b == Blocks.field_150378_br;
    }

    public TranslationTextComponent ouch(PlayerEntity owner) {
        Random rand = owner.func_70681_au();
        int textNum = 1 + rand.nextInt(7);
        TranslationTextComponent tct = new TranslationTextComponent("mahoutsukai.hurt" + textNum, new Object[0]);
        return tct;
    }

    public TranslationTextComponent getGreeting(PlayerEntity owner) {
        TranslationTextComponent tct = new TranslationTextComponent("", new Object[0]);
        Random rand = owner.func_70681_au();
        int textNum = rand.nextInt(7);
        if (textNum > 0) {
            if (this.getHoliday() && this.whichHoliday() != 0) {
                tct.func_150257_a((ITextComponent)new TranslationTextComponent("mahoutsukai.holiday" + this.whichHoliday() + "greeting" + textNum, new Object[0]));
            } else {
                tct.func_150257_a((ITextComponent)new TranslationTextComponent("mahoutsukai.greeting" + textNum, new Object[0]));
            }
            tct.func_150258_a(" ");
        }
        tct.func_150257_a((ITextComponent)new TranslationTextComponent("mahoutsukai.masta", new Object[0]));
        tct.func_150258_a(", ");
        return tct;
    }

    public TranslationTextComponent reportBlock(Block thing, PlayerEntity owner) {
        TranslationTextComponent tct = null;
        Random rand = owner.func_70681_au();
        if (thing != null) {
            tct = this.getGreeting(owner);
            int textNum = 1 + rand.nextInt(3);
            tct.func_150257_a((ITextComponent)new TranslationTextComponent("mahoutsukai.found" + textNum, new Object[0]));
            tct.func_150258_a(" ");
            tct.func_150257_a((ITextComponent)new TranslationTextComponent(new TranslationTextComponent(thing.func_149739_a(), new Object[0]).func_150261_e(), new Object[0]));
            tct.func_150258_a(" ");
            tct.func_150257_a((ITextComponent)new TranslationTextComponent("mahoutsukai.foundF" + textNum, new Object[0]));
            tct.func_150258_a(" ");
            textNum = 1 + rand.nextInt(4);
            tct.func_150257_a((ITextComponent)new TranslationTextComponent("mahoutsukai.followup" + textNum, new Object[0]));
        }
        return tct;
    }

    public TranslationTextComponent reportEntity(LivingEntity thing, PlayerEntity owner) {
        TranslationTextComponent tct = null;
        Random rand = owner.func_70681_au();
        if (thing != null && !(thing instanceof PlayerEntity) && thing != this) {
            tct = this.getGreeting(owner);
            int textNum = 1 + rand.nextInt(3);
            tct.func_150257_a((ITextComponent)new TranslationTextComponent("mahoutsukai.entityFound" + textNum, new Object[0]));
            tct.func_150258_a(" ");
            tct.func_150257_a((ITextComponent)new TranslationTextComponent(thing.func_200200_C_().func_150261_e(), new Object[0]));
            tct.func_150258_a(" ");
            tct.func_150257_a((ITextComponent)new TranslationTextComponent("mahoutsukai.entityFoundF" + textNum, new Object[0]));
            tct.func_150258_a(" ");
            textNum = 1 + rand.nextInt(7);
            tct.func_150257_a((ITextComponent)new TranslationTextComponent("mahoutsukai.entityFoundFollowUp" + textNum, new Object[0]));
        }
        return tct;
    }

    public TranslationTextComponent reportPlayer(PlayerEntity player, PlayerEntity owner) {
        TranslationTextComponent tct = null;
        Random rand = owner.func_70681_au();
        if (player != null && !ContractMahoujinTileEntity.isImmuneToSpell(this.field_70170_p, this.func_184753_b(), (Entity)player)) {
            tct = this.getGreeting(owner);
            BlockPos position = player.func_180425_c();
            int textNum = 1 + rand.nextInt(3);
            tct.func_150257_a((ITextComponent)new TranslationTextComponent("mahoutsukai.playerFound" + textNum, new Object[0]));
            tct.func_150258_a(" ");
            tct.func_150257_a((ITextComponent)new TranslationTextComponent(player.func_200200_C_().func_150261_e(), new Object[0]));
            tct.func_150257_a((ITextComponent)new TranslationTextComponent("mahoutsukai.playerFoundF" + textNum, new Object[0]));
            tct.func_150258_a(" ");
            tct.func_150258_a("[" + position.func_177958_n() + "," + position.func_177956_o() + "," + position.func_177952_p() + "]. ");
            textNum = 1 + rand.nextInt(7);
            tct.func_150257_a((ITextComponent)new TranslationTextComponent("mahoutsukai.entityFoundFollowUp" + textNum, new Object[0]));
        }
        return tct;
    }

    public void loadChunks() {
        if (this.ticket == null && !this.field_70170_p.field_72995_K && this.func_70902_q() != null) {
            this.ticket = TicketType.func_219484_a((String)(this.func_70902_q().func_200200_C_() + "familiar"), Comparator.comparingLong(ChunkPos::func_201841_a));
        } else if (this.ticket != null && !this.field_70170_p.field_72995_K && this.func_70902_q() != null) {
            ChunkPos pos = new ChunkPos(this.func_180425_c());
            ((ServerWorld)this.field_70170_p).func_72863_F().func_217228_a(this.ticket, pos, 1, (Object)pos);
        }
    }

    public ChunkPos add(int x, int z, ChunkPos pos) {
        return new ChunkPos(pos.field_77276_a + x, pos.field_77275_b + z);
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.ticket != null) {
            ((ServerWorld)this.field_70170_p).func_72863_F().func_217222_b(this.ticket, new ChunkPos(this.func_180425_c()), 1, (Object)new ChunkPos(this.func_180425_c()));
            this.ticket = null;
        }
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.flapSpeed = MathHelper.func_76131_a((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        if (!this.field_70122_E && this.func_213322_ci().field_72448_b < 0.0) {
            Vec3d motion = this.func_213322_ci();
            this.func_213293_j(motion.field_72450_a, motion.field_72448_b * 0.6, motion.field_72449_c);
        }
        this.flap += this.flapping * 2.0f;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (!this.field_70170_p.field_72995_K && !this.isFlying() && this.func_152114_e((LivingEntity)player)) {
            this.field_70911_d.func_75270_a(!this.func_70906_o());
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public boolean func_213380_a(IWorld p_213380_1_, SpawnReason p_213380_2_) {
        return false;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        return entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 3.0f);
    }

    public boolean func_70104_M() {
        return true;
    }

    protected void func_82167_n(Entity entityIn) {
        if (!(entityIn instanceof PlayerEntity)) {
            super.func_82167_n(entityIn);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_190530_aW()) {
            return false;
        }
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (this.func_70902_q() != null && !this.field_70170_p.field_72995_K && this.func_70681_au().nextDouble() > MTConfig.FAMILIAR_OUCH_CHANCE) {
            this.func_70902_q().func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.AQUA + this.getMyName() + ": " + this.ouch((PlayerEntity)this.func_70902_q()).func_150261_e()));
        }
        return super.func_70097_a(source, amount);
    }

    public UUID getFamiliarId() {
        return this.familiarId;
    }

    public void setFamiliarId(UUID f) {
        this.familiarId = f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR_R, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_G, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_B, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(GARDEN_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(HOLIDAY, (Object)true);
    }

    public void setColor(float r, float g, float b) {
        this.field_70180_af.func_187227_b(COLOR_R, (Object)Float.valueOf(r));
        this.field_70180_af.func_187227_b(COLOR_G, (Object)Float.valueOf(g));
        this.field_70180_af.func_187227_b(COLOR_B, (Object)Float.valueOf(b));
    }

    public float[] getColor() {
        return new float[]{((Float)this.field_70180_af.func_187225_a(COLOR_R)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_G)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_B)).floatValue()};
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.familiarId != null) {
            compound.func_186854_a("mahoutsukai_familiar_id", this.familiarId);
        }
        if (this.func_184753_b() != null) {
            compound.func_186854_a("mahoutsukai_familiar_owner_id", this.func_184753_b());
        }
        float[] colors = this.getColor();
        compound.func_74776_a(TAG_COLOR_R, colors[0]);
        compound.func_74776_a(TAG_COLOR_G, colors[1]);
        compound.func_74776_a(TAG_COLOR_B, colors[2]);
        compound.func_74768_a(TAG_GARDEN_TICKS, this.getGardenTicks());
        compound.func_74757_a(TAG_HOLIDAY, this.getHoliday());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_186855_b("mahoutsukai_familiar_id")) {
            this.familiarId = compound.func_186857_a("mahoutsukai_familiar_id");
        }
        if (compound.func_186855_b("mahoutsukai_familiar_owner_id")) {
            this.func_184754_b(compound.func_186857_a("mahoutsukai_familiar_owner_id"));
        }
        this.setColor(compound.func_74760_g(TAG_COLOR_R), compound.func_74760_g(TAG_COLOR_G), compound.func_74760_g(TAG_COLOR_B));
        this.setGardenTicks(compound.func_74762_e(TAG_GARDEN_TICKS));
        this.setHoliday(compound.func_74767_n(TAG_HOLIDAY));
    }

    public boolean isFlying() {
        return !this.field_70122_E;
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageableEntity) {
        return null;
    }
}

