/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.projection;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import stepsword.mahoutsukai.item.spells.SpellScroll;

public class StrengtheningSpellEffect {
    public static final String STRENGTHENED_TAG = "mahoutsukai_strengthened";
    public static final String UNBREAKABLE_TAG = "mahoutsukai_old_unbreakable";
    public static final int STRENGTHENED_USES = 5;
    public static final float STRENGTHENED_DAMAGE_BUFF = 4.0f;

    public static void strengtheningLivingHurt(LivingHurtEvent event) {
        EntityDamageSource entityDamageSource;
        Entity trueSource;
        DamageSource source = event.getSource();
        ItemStack weapon = null;
        if (source.field_76373_n != "arrow" && source.field_76373_n == "player" && source instanceof EntityDamageSource && (trueSource = (entityDamageSource = (EntityDamageSource)source).func_76346_g()) instanceof PlayerEntity) {
            PlayerEntity attacker = (PlayerEntity)trueSource;
            weapon = attacker.func_184614_ca();
        }
        if (weapon != null && StrengtheningSpellEffect.getStrengthened(weapon) > 0) {
            event.setAmount(event.getAmount() + 4.0f);
            StrengtheningSpellEffect.reduceStrengthened(weapon, 1);
        }
    }

    public static void strengtheningHarvestCheck(PlayerEvent.HarvestCheck event) {
        ItemStack s;
        PlayerEntity player = event.getPlayer();
        if (player != null && StrengtheningSpellEffect.getStrengthened(s = player.func_184614_ca()) > 0) {
            int blockLevel = event.getTargetBlock().func_177230_c().getHarvestLevel(event.getTargetBlock());
            if (s.func_77973_b() instanceof PickaxeItem) {
                event.setCanHarvest(true);
            } else if (blockLevel <= 1) {
                event.setCanHarvest(true);
            }
        }
    }

    public static void strengtheningBreakEvent(BlockEvent.BreakEvent event) {
        PlayerEntity player;
        if (!event.getPlayer().field_70170_p.field_72995_K && (player = event.getPlayer()) != null) {
            ItemStack s = player.func_184614_ca();
            BlockState b = event.getState();
            if (StrengtheningSpellEffect.getStrengthened(s) > 0 && s.func_77973_b() instanceof ToolItem) {
                StrengtheningSpellEffect.reduceStrengthened(s, 1);
            } else if (StrengtheningSpellEffect.getStrengthened(s) > 0) {
                StrengtheningSpellEffect.reduceStrengthened(s, 1);
            }
        }
    }

    public static void strengtheningBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack s;
        PlayerEntity player = event.getPlayer();
        if (player != null && StrengtheningSpellEffect.getStrengthened(s = player.func_184614_ca()) > 0) {
            event.setNewSpeed(event.getNewSpeed() + 3.0f);
        }
    }

    public static void reduceStrengthened(ItemStack stack, int reduce) {
        CompoundNBT nbt;
        if (stack != null && !stack.func_190926_b() && stack.func_77942_o() && (nbt = stack.func_77978_p()) != null && nbt.func_74764_b(STRENGTHENED_TAG)) {
            nbt.func_74768_a(STRENGTHENED_TAG, nbt.func_74762_e(STRENGTHENED_TAG) - reduce);
            if (nbt.func_74762_e(STRENGTHENED_TAG) <= 0) {
                if (nbt.func_74764_b(UNBREAKABLE_TAG)) {
                    nbt.func_74757_a("Unbreakable", nbt.func_74767_n(UNBREAKABLE_TAG));
                } else {
                    nbt.func_74757_a("Unbreakable", false);
                }
            }
        }
    }

    public static void setStrengthened(ItemStack stack, World world) {
        if (!world.field_72995_K && stack != null && !stack.func_190926_b()) {
            CompoundNBT nbt = stack.func_77978_p();
            int alreadyStrengthened = 0;
            if (nbt == null) {
                nbt = new CompoundNBT();
            } else {
                alreadyStrengthened = StrengtheningSpellEffect.getStrengthened(stack);
            }
            if (alreadyStrengthened == 0 && nbt.func_74764_b("Unbreakable")) {
                nbt.func_74757_a(UNBREAKABLE_TAG, nbt.func_74767_n("Unbreakable"));
            } else {
                nbt.func_74757_a(UNBREAKABLE_TAG, false);
            }
            nbt.func_74757_a("Unbreakable", true);
            nbt.func_74768_a(STRENGTHENED_TAG, alreadyStrengthened + 5);
            stack.func_77982_d(nbt);
        }
    }

    public static int getStrengthened(ItemStack stack) {
        CompoundNBT nbt;
        if (stack != null && !stack.func_190926_b() && (nbt = stack.func_77978_p()) != null && nbt.func_74764_b(STRENGTHENED_TAG)) {
            return nbt.func_74762_e(STRENGTHENED_TAG);
        }
        return 0;
    }

    public static ItemStack findStackToStrengthen(PlayerEntity p) {
        ItemStack stack = null;
        if (p != null && ((stack = p.func_184592_cb()) == null || stack.func_190926_b())) {
            for (int i = 0; i < 10 && ((stack = p.field_71071_by.func_70301_a(i)) == null || stack.func_190926_b() || stack.func_77973_b() instanceof SpellScroll); ++i) {
            }
        }
        return stack;
    }
}

