/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ding.common;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ding")
public class Ding {
    public static final String MOD_ID = "ding";
    public static final String MOD_NAME = "Ding";
    private static final Logger LOGGER = LogManager.getLogger();
    public static Config config;

    public Ding() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            this.setupConfig();
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::finishLoading);
        });
        DistExecutor.runWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> LOGGER.log(Level.ERROR, "You are loading Ding on a server. Ding is a client only mod!"));
    }

    private void setupConfig() {
        ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
        config = new Config(configBuilder);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, configBuilder.build(), "ding.toml");
    }

    private void finishLoading(FMLLoadCompleteEvent event) {
        EventHandler.postInit = true;
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class EventHandler {
        public static boolean postInit;
        public static boolean played;
        public static boolean playWorld;

        @SubscribeEvent
        public static void onGuiOpen(GuiOpenEvent event) {
            if (postInit && event.getGui() instanceof MainMenuScreen && !played) {
                played = true;
                int playOn = (Integer)Ding.config.playOn.get();
                if ((playOn & 1) > 0) {
                    String name = (String)Ding.config.name.get();
                    SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(name));
                    if (sound != null) {
                        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)sound, (float)((Double)Ding.config.pitch.get()).floatValue()));
                    } else {
                        LOGGER.log(Level.WARN, "Could not find sound: {}", (Object)new ResourceLocation(name));
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onClientLoggedInEvent(ClientPlayerNetworkEvent.LoggedInEvent event) {
            playWorld = true;
        }

        @SubscribeEvent
        public static void onWorldTick(TickEvent.WorldTickEvent event) {
            if (playWorld && event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71439_g != null && (Minecraft.func_71410_x().field_71439_g.field_70173_aa > 20 || Minecraft.func_71410_x().func_147113_T())) {
                playWorld = false;
                int playOn = (Integer)Ding.config.playOn.get();
                if ((playOn & 2) > 0) {
                    String nameWorld = (String)Ding.config.nameWorld.get();
                    SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(nameWorld));
                    if (sound != null) {
                        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)sound, (float)((Double)Ding.config.pitchWorld.get()).floatValue()));
                    } else {
                        LOGGER.log(Level.WARN, "Could not find sound: {}", (Object)new ResourceLocation(nameWorld));
                    }
                }
            }
        }
    }

    public class Config {
        public final ForgeConfigSpec.ConfigValue<String> name;
        public final ForgeConfigSpec.DoubleValue pitch;
        public final ForgeConfigSpec.ConfigValue<String> nameWorld;
        public final ForgeConfigSpec.DoubleValue pitchWorld;
        public final ForgeConfigSpec.IntValue playOn;

        public Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Configs related to how ding works").push(Ding.MOD_ID);
            this.name = builder.comment("Resource Location based name of the sound file to play when Minecraft finishes loading.\nEG: \"ui.button.click\" or \"entity.experience_orb.pickup\"\n\nThis can also be a mod sound if the mod is installed.\nEG: \"modname:modsound.boing\"\n\nIf you want to use external sounds, consider looking into the mod Additional Resources").translation("config.ding.prop.name.desc").define("name", (Object)"entity.experience_orb.pickup");
            this.pitch = builder.comment("Pitch of the sound (when Minecraft loads)").translation("config.ding.prop.pitch.desc").defineInRange("pitch", 1.0, 0.0, 10.0);
            this.nameWorld = builder.comment("Resource Location based name of the sound file to play when the world finishes loading.\nEG: \"ui.button.click\" or \"entity.experience_orb.pickup\"\n\nThis can also be a mod sound if the mod is installed.\nEG: \"modname:modsound.boing\"\n\nIf you want to use external sounds, consider looking into the mod Additional Resources").translation("config.ding.prop.nameWorld.desc").define("nameWorld", (Object)"entity.experience_orb.pickup");
            this.pitchWorld = builder.comment("Pitch of the sound (when the world loads)").translation("config.ding.prop.pitchWorld.desc").defineInRange("pitchWorld", 1.0, 0.0, 10.0);
            this.playOn = builder.comment("Play sound on...\n0 = Nothing (why install the mod though?)\n1 = MC load\n2 = World load\n3 = MC and World load").translation("config.ding.prop.playOn.desc").defineInRange("playOn", 1, 0, 3);
            builder.pop();
        }
    }
}

