/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.ai;

import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import vazkii.quark.tweaks.module.PatTheDogsModule;

public class WantLoveGoal
extends Goal {
    private static final String PET_TIME = "quark:PetTime";
    private final TameableEntity creature;
    private LivingEntity leapTarget;
    public final float leapUpMotion;

    public static void setPetTime(TameableEntity entity) {
        entity.getPersistentData().func_74772_a(PET_TIME, entity.field_70170_p.func_82737_E());
    }

    public static boolean canPet(TameableEntity entity) {
        return WantLoveGoal.timeSinceLastPet(entity) > 20L;
    }

    public static boolean needsPets(TameableEntity entity) {
        if (PatTheDogsModule.dogsWantLove <= 0) {
            return false;
        }
        return WantLoveGoal.timeSinceLastPet(entity) > (long)PatTheDogsModule.dogsWantLove;
    }

    public static long timeSinceLastPet(TameableEntity entity) {
        if (!entity.func_70909_n()) {
            return 0L;
        }
        long lastPetAt = entity.getPersistentData().func_74763_f(PET_TIME);
        return entity.field_70170_p.func_82737_E() - lastPetAt;
    }

    public WantLoveGoal(TameableEntity creature, float leapMotion) {
        this.creature = creature;
        this.leapUpMotion = leapMotion;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.TARGET));
    }

    public boolean func_75250_a() {
        if (!WantLoveGoal.needsPets(this.creature)) {
            return false;
        }
        this.leapTarget = this.creature.func_70902_q();
        if (this.leapTarget == null) {
            return false;
        }
        double distanceToTarget = this.creature.func_70068_e((Entity)this.leapTarget);
        return 4.0 <= distanceToTarget && distanceToTarget <= 16.0 && this.creature.field_70122_E && this.creature.func_70681_au().nextInt(5) == 0;
    }

    public boolean func_75253_b() {
        if (!WantLoveGoal.needsPets(this.creature)) {
            return false;
        }
        return !this.creature.field_70122_E;
    }

    public void func_75249_e() {
        Vec3d leapPos = this.leapTarget.func_213303_ch();
        Vec3d creaturePos = this.creature.func_213303_ch();
        double dX = leapPos.field_72450_a - creaturePos.field_72450_a;
        double dZ = leapPos.field_72449_c - creaturePos.field_72449_c;
        float leapMagnitude = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
        Vec3d motion = this.creature.func_213322_ci();
        if ((double)leapMagnitude >= 1.0E-4) {
            motion = motion.func_72441_c(dX / (double)leapMagnitude * 0.4 + motion.field_72450_a * 0.2, 0.0, dZ / (double)leapMagnitude * 0.4 + motion.field_72449_c * 0.2);
        }
        motion = motion.func_72441_c(0.0, (double)this.leapUpMotion, 0.0);
        this.creature.func_213317_d(motion);
    }
}

