/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.Module;
import vazkii.quark.oddities.module.TotemOfHoldingModule;

public class SoulCompassItem
extends QuarkItem {
    private static final String TAG_POS_X = "posX";
    private static final String TAG_POS_Y = "posY";
    private static final String TAG_POS_Z = "posZ";
    @OnlyIn(value=Dist.CLIENT)
    private static double rotation;
    @OnlyIn(value=Dist.CLIENT)
    private static double rota;
    @OnlyIn(value=Dist.CLIENT)
    private static long lastUpdateTick;

    public SoulCompassItem(Module module) {
        super("soul_compass", module, new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200917_a(1));
        this.func_185043_a(new ResourceLocation("angle"), (stack, world, entityIn) -> {
            double angle;
            BlockPos pos;
            LivingEntity entity;
            if (entityIn == null && !stack.func_82839_y()) {
                return 0.0f;
            }
            boolean hasEntity = entityIn != null;
            Object object = entity = hasEntity ? entityIn : stack.func_82836_z();
            if (entity == null) {
                return 0.0f;
            }
            if (world == null) {
                world = entity.field_70170_p;
            }
            if ((pos = this.getPos(stack)).func_177956_o() == world.func_201675_m().func_186058_p().func_186068_a()) {
                double yaw = hasEntity ? (double)entity.field_70177_z : this.getFrameRotation((ItemFrameEntity)entity);
                yaw = MathHelper.func_191273_b((double)(yaw / 360.0), (double)1.0);
                double relAngle = this.getDeathToAngle((Entity)entity, pos) / (Math.PI * 2);
                angle = 0.5 - (yaw - 0.25 - relAngle);
            } else {
                angle = Math.random();
            }
            if (hasEntity) {
                angle = this.wobble(world, angle);
            }
            return MathHelper.func_188207_b((float)((float)angle), (float)1.0f);
        });
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K) {
            BlockPos pos = TotemOfHoldingModule.getPlayerDeathPosition(entityIn);
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_X, (int)pos.func_177958_n());
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_Y, (int)pos.func_177956_o());
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_Z, (int)pos.func_177952_p());
        }
    }

    private BlockPos getPos(ItemStack stack) {
        if (stack.func_77942_o()) {
            int x = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_X, (int)0);
            int y = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_Y, (int)-1);
            int z = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_Z, (int)0);
            return new BlockPos(x, y, z);
        }
        return new BlockPos(0, -1, 0);
    }

    @OnlyIn(value=Dist.CLIENT)
    private double wobble(World worldIn, double angle) {
        if (worldIn.func_82737_E() != lastUpdateTick) {
            lastUpdateTick = worldIn.func_82737_E();
            double relAngle = angle - rotation;
            relAngle = MathHelper.func_191273_b((double)(relAngle + 0.5), (double)1.0) - 0.5;
            rota += relAngle * 0.1;
            rotation = MathHelper.func_191273_b((double)(rotation + (rota *= 0.8)), (double)1.0);
        }
        return rotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    private double getFrameRotation(ItemFrameEntity frame) {
        Direction facing = frame.func_174811_aO();
        return MathHelper.func_76142_g((float)(180.0f + facing.func_185119_l()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private double getDeathToAngle(Entity entity, BlockPos blockpos) {
        return Math.atan2((double)blockpos.func_177952_p() - entity.func_226281_cx_(), (double)blockpos.func_177958_n() - entity.func_226277_ct_());
    }
}

