/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.management.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import vazkii.quark.base.client.TopLayerTooltipHandler;
import vazkii.quark.base.handler.MiscUtil;

public class MiniInventoryButton
extends Button {
    private final Consumer<List<String>> tooltip;
    private final int type;
    private final ContainerScreen<?> parent;
    private final int startX;
    private BooleanSupplier shiftTexture = () -> false;

    public MiniInventoryButton(ContainerScreen<?> parent, int type, int x, int y, Consumer<List<String>> tooltip, Button.IPressable onPress) {
        super(parent.getGuiLeft() + x, parent.getGuiTop() + y, 10, 10, "", onPress);
        this.parent = parent;
        this.type = type;
        this.tooltip = tooltip;
        this.startX = x;
    }

    public MiniInventoryButton(ContainerScreen<?> parent, int type, int x, int y, String tooltip, Button.IPressable onPress) {
        this(parent, type, x, y, (List<String> t) -> t.add(I18n.func_135052_a((String)tooltip, (Object[])new Object[0])), onPress);
    }

    public MiniInventoryButton setTextureShift(BooleanSupplier func) {
        this.shiftTexture = func;
        return this;
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        if (this.parent instanceof IRecipeShownListener) {
            this.x = this.parent.getGuiLeft() + this.startX;
        }
        super.render(p_render_1_, p_render_2_, p_render_3_);
    }

    public void renderButton(int mouseX, int mouseY, float pticks) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(MiscUtil.GENERAL_ICONS);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        RenderSystem.disableLighting();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int u = this.type * this.width;
        int v = 25 + (this.isHovered ? this.height : 0);
        if (this.shiftTexture.getAsBoolean()) {
            v += this.height * 2;
        }
        this.blit(this.x, this.y, u, v, this.width, this.height);
        if (this.isHovered) {
            TopLayerTooltipHandler.setTooltip(this.getTooltip(), mouseX, mouseY);
        }
    }

    protected String getNarrationMessage() {
        List<String> tooltip = this.getTooltip();
        return tooltip.isEmpty() ? "" : I18n.func_135052_a((String)"gui.narrate.button", (Object[])new Object[]{this.getTooltip().get(0)});
    }

    public List<String> getTooltip() {
        LinkedList<String> list = new LinkedList<String>();
        this.tooltip.accept(list);
        return list;
    }
}

