/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.building.block;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import vazkii.arl.interf.IBlockItemProvider;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.module.Module;
import vazkii.quark.building.client.render.VariantChestTileEntityRenderer;
import vazkii.quark.building.module.VariantChestsModule;
import vazkii.quark.building.tile.VariantChestTileEntity;

@OnlyIn(value=Dist.CLIENT, _interface=IBlockItemProvider.class)
public class VariantChestBlock
extends ChestBlock
implements IBlockItemProvider,
IQuarkBlock,
VariantChestsModule.IChestTextureProvider {
    public final String type;
    private final Module module;
    private BooleanSupplier enabledSupplier = () -> true;
    private String path;

    public VariantChestBlock(String type, Module module, Supplier<TileEntityType<? extends ChestTileEntity>> supplier, Block.Properties props) {
        super(props, supplier);
        RegistryHelper.registerBlock((Block)this, (String)(type + "_chest"));
        RegistryHelper.setCreativeTab((Block)this, (ItemGroup)ItemGroup.field_78031_c);
        this.type = type;
        this.module = module;
        this.path = (this instanceof Compat ? "compat/" : "") + type + "/";
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return false;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == ItemGroup.field_78027_g) {
            super.func_149666_a(group, items);
        }
    }

    @Override
    public VariantChestBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.module;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new VariantChestTileEntity();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setISTER(Item.Properties props, final Block block) {
        props.setISTER(() -> () -> new ItemStackTileEntityRenderer(){
            private final TileEntity tile = new VariantChestTileEntity();

            public void func_228364_a_(ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int x, int y) {
                VariantChestTileEntityRenderer.invBlock = block;
                TileEntityRendererDispatcher.field_147556_a.func_228852_a_(this.tile, matrix, buffer, x, y);
                VariantChestTileEntityRenderer.invBlock = null;
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockItem provideItemBlock(Block block, Item.Properties props) {
        VariantChestBlock.setISTER(props, block);
        return new BlockItem(block, props);
    }

    @Override
    public String getChestTexturePath() {
        return "model/chest/" + this.path;
    }

    @Override
    public boolean isTrap() {
        return false;
    }

    public static class Compat
    extends VariantChestBlock {
        public Compat(String type, String mod, Module module, Supplier<TileEntityType<? extends ChestTileEntity>> supplier, Block.Properties props) {
            super(type, module, supplier, props);
            this.setCondition(() -> ModList.get().isLoaded(mod));
        }
    }
}

