/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import vazkii.quark.base.module.ConfigFlagManager;

public class FlagLootCondition
implements ILootCondition {
    private final ConfigFlagManager manager;
    private final String flag;

    public FlagLootCondition(ConfigFlagManager manager, String flag) {
        this.manager = manager;
        this.flag = flag;
    }

    public boolean test(LootContext lootContext) {
        return this.manager.getFlag(this.flag);
    }

    public static class Serializer
    extends ILootCondition.AbstractSerializer<FlagLootCondition> {
        private final ConfigFlagManager manager;

        public Serializer(ConfigFlagManager manager, ResourceLocation location) {
            super(location, FlagLootCondition.class);
            this.manager = manager;
        }

        public void serialize(@Nonnull JsonObject json, @Nonnull FlagLootCondition value, @Nonnull JsonSerializationContext context) {
            json.addProperty("flag", value.flag);
        }

        @Nonnull
        public FlagLootCondition deserialize(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context) {
            return new FlagLootCondition(this.manager, json.getAsJsonPrimitive("flag").getAsString());
        }
    }
}

