/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class RayTraceHandler {
    public static RayTraceResult rayTrace(Entity entity, World world, PlayerEntity player, RayTraceContext.BlockMode blockMode, RayTraceContext.FluidMode fluidMode) {
        return RayTraceHandler.rayTrace(entity, world, (Entity)player, blockMode, fluidMode, RayTraceHandler.getEntityRange((LivingEntity)player));
    }

    public static RayTraceResult rayTrace(Entity entity, World world, Entity player, RayTraceContext.BlockMode blockMode, RayTraceContext.FluidMode fluidMode, double range) {
        Pair<Vec3d, Vec3d> params = RayTraceHandler.getEntityParams(player);
        return RayTraceHandler.rayTrace(entity, world, (Vec3d)params.getLeft(), (Vec3d)params.getRight(), blockMode, fluidMode, range);
    }

    public static RayTraceResult rayTrace(Entity entity, World world, Vec3d startPos, Vec3d ray, RayTraceContext.BlockMode blockMode, RayTraceContext.FluidMode fluidMode, double range) {
        return RayTraceHandler.rayTrace(entity, world, startPos, ray.func_186678_a(range), blockMode, fluidMode);
    }

    public static RayTraceResult rayTrace(Entity entity, World world, Vec3d startPos, Vec3d ray, RayTraceContext.BlockMode blockMode, RayTraceContext.FluidMode fluidMode) {
        Vec3d end = startPos.func_178787_e(ray);
        RayTraceContext context = new RayTraceContext(startPos, end, blockMode, fluidMode, entity);
        return world.func_217299_a(context);
    }

    public static double getEntityRange(LivingEntity player) {
        return player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
    }

    public static Pair<Vec3d, Vec3d> getEntityParams(Entity player) {
        float scale = 1.0f;
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * scale;
        float yaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * scale;
        Vec3d pos = player.func_213303_ch();
        double posX = player.field_70169_q + (pos.field_72450_a - player.field_70169_q) * (double)scale;
        double posY = player.field_70167_r + (pos.field_72448_b - player.field_70167_r) * (double)scale;
        if (player instanceof PlayerEntity) {
            posY += (double)((PlayerEntity)player).func_70047_e();
        }
        double posZ = player.field_70166_s + (pos.field_72449_c - player.field_70166_s) * (double)scale;
        Vec3d rayPos = new Vec3d(posX, posY, posZ);
        float zYaw = -MathHelper.func_76134_b((float)(yaw * (float)Math.PI / 180.0f));
        float xYaw = MathHelper.func_76126_a((float)(yaw * (float)Math.PI / 180.0f));
        float pitchMod = -MathHelper.func_76134_b((float)(pitch * (float)Math.PI / 180.0f));
        float azimuth = -MathHelper.func_76126_a((float)(pitch * (float)Math.PI / 180.0f));
        float xLen = xYaw * pitchMod;
        float yLen = zYaw * pitchMod;
        Vec3d ray = new Vec3d((double)xLen, (double)azimuth, (double)yLen);
        return Pair.of((Object)rayPos, (Object)ray);
    }
}

