/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.setup;

import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.setup.IProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
implements IProxy {
    @Override
    public void setup() {
        for (BlockBase b : BlockRegistry.blocks) {
            b.registerClient();
        }
        this.initColours();
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void setPlayerReach(PlayerEntity player, int currentReach) {
        player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111128_a((double)currentReach);
    }

    private void initColours() {
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, tintIndex) -> {
            if (stack.func_77942_o() && tintIndex > 0) {
                EntityType thing = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(stack.func_77978_p().func_74779_i("cyclic:magicnet_id")));
                for (SpawnEggItem spawneggitem : SpawnEggItem.func_195985_g()) {
                    if (spawneggitem.func_208076_b(null) != thing) continue;
                    return spawneggitem.func_195983_a(tintIndex - 1);
                }
            }
            return -1;
        }, new IItemProvider[]{ItemRegistry.mob_container});
    }
}

