/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.bauble;

import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.util.UtilEntity;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilParticle;
import com.lothrazar.cyclic.util.UtilSound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class CharmBase
extends ItemBase {
    private static final int yLowest = -30;
    private static final int yDest = 255;
    private static final int fireProtSeconds = 10;
    boolean fireProt;
    boolean poisonProt;
    boolean witherProt;
    boolean voidProt;

    public CharmBase(Item.Properties properties) {
        super(properties);
    }

    private boolean canUse(ItemStack stack) {
        return stack.func_77952_i() < stack.func_77958_k();
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!this.canUse(stack)) {
            return;
        }
        this.tryVoidTick(stack, worldIn, entityIn);
        if (!(entityIn instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entityIn;
        this.tryPoisonTick(stack, entityIn, living);
        this.tryWitherTick(stack, entityIn, living);
        this.tryFireTick(stack, living);
    }

    private void tryFireTick(ItemStack stack, LivingEntity living) {
        if (this.fireProt && living.func_70027_ad() && !living.func_70644_a(Effects.field_76426_n)) {
            living.func_195064_c(new EffectInstance(Effects.field_76426_n, 200, 0));
            UtilItemStack.damageItem(living, stack);
            UtilSound.playSound((Entity)living, living.func_180425_c(), SoundEvents.field_187646_bt);
            UtilParticle.spawnParticle(living.field_70170_p, (IParticleData)ParticleTypes.field_197618_k, living.func_180425_c(), 9);
        }
    }

    private void tryWitherTick(ItemStack stack, Entity entityIn, LivingEntity living) {
        if (this.witherProt && living.func_70644_a(Effects.field_82731_v)) {
            living.func_184596_c(Effects.field_82731_v);
            UtilItemStack.damageItem(living, stack);
            UtilSound.playSound(entityIn, entityIn.func_180425_c(), SoundEvents.field_187664_bz);
        }
    }

    private void tryPoisonTick(ItemStack stack, Entity entityIn, LivingEntity living) {
        if (this.poisonProt && living.func_70644_a(Effects.field_76436_u)) {
            living.func_184596_c(Effects.field_76436_u);
            UtilItemStack.damageItem(living, stack);
            UtilSound.playSound(entityIn, entityIn.func_180425_c(), SoundEvents.field_187664_bz);
        }
    }

    private void tryVoidTick(ItemStack stack, World worldIn, Entity entityIn) {
        if (this.voidProt && entityIn.func_180425_c().func_177956_o() < -30) {
            UtilEntity.teleportWallSafe(entityIn, worldIn, new BlockPos(entityIn.func_180425_c().func_177958_n(), 255, entityIn.func_180425_c().func_177952_p()));
            if (entityIn instanceof LivingEntity) {
                UtilItemStack.damageItem((LivingEntity)entityIn, stack);
            }
            UtilSound.playSound(entityIn, entityIn.func_180425_c(), SoundEvents.field_187534_aX);
        }
    }
}

