/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.api.util;

import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.api.capability.IConnectable;
import com.lothrazar.storagenetwork.api.data.IItemStackMatcher;
import com.lothrazar.storagenetwork.api.data.ItemStackMatcher;
import com.lothrazar.storagenetwork.block.master.TileMaster;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.text.WordUtils;

public class UtilTileEntity {
    private static final Map<String, String> modNamesForIds = new HashMap<String, String>();
    public static final int MOUSE_BTN_LEFT = 0;
    public static final int MOUSE_BTN_RIGHT = 1;
    public static final int MOUSE_BTN_MIDDLE_CLICK = 2;

    public static void init() {
    }

    @Nullable
    public static TileMaster getTileMasterForConnectable(@Nonnull IConnectable connectable) {
        if (connectable == null || connectable.getMasterPos() == null) {
            return null;
        }
        return connectable.getMasterPos().getTileEntity(TileMaster.class);
    }

    public static IItemStackMatcher createItemStackMatcher(ItemStack stack, boolean ore, boolean nbt) {
        return new ItemStackMatcher(stack, ore, nbt);
    }

    @Nonnull
    public static String getModNameForItem(@Nonnull Object object) {
        ResourceLocation itemResourceLocation;
        if (object instanceof Item) {
            itemResourceLocation = ((Item)object).getRegistryName();
        } else if (object instanceof Block) {
            itemResourceLocation = ((Block)object).getRegistryName();
        } else {
            return null;
        }
        String modId = itemResourceLocation.func_110624_b();
        String lowercaseModId = modId.toLowerCase(Locale.ENGLISH);
        String modName = modNamesForIds.get(lowercaseModId);
        if (modName == null) {
            modName = WordUtils.capitalize((String)modId);
            modNamesForIds.put(lowercaseModId, modName);
        }
        return modName;
    }

    public static <E> boolean contains(List<E> list, E e, Comparator<? super E> c) {
        for (E a : list) {
            if (c.compare(a, e) != 0) continue;
            return true;
        }
        return false;
    }

    public static void spawnItemStack(World worldIn, double x, double y, double z, ItemStack stack) {
        if (stack == null || stack.func_190926_b() || worldIn.field_72995_K) {
            return;
        }
        float f = 0.1f;
        float f1 = 0.8f;
        float f2 = 0.1f;
        ItemEntity entityitem = new ItemEntity(worldIn, x + (double)f, y + (double)f1, z + (double)f2, stack);
        worldIn.func_217376_c((Entity)entityitem);
    }

    public static List<BlockPos> getSides(BlockPos pos) {
        ArrayList lis = Lists.newArrayList();
        for (Direction face : Direction.values()) {
            lis.add(pos.func_177972_a(face));
        }
        return lis;
    }

    public static void updateTile(World world, BlockPos pos) {
    }
}

