/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.world;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IEntityReader;

public class Collisions {
    private static final double MOTION_MULT_LENGHT = 1.0E-7;

    public static boolean hasNoCollisions(Entity entity, Object world) {
        return Collisions.hasNoCollisions(entity, entity.func_174813_aQ(), world);
    }

    public static boolean hasNoCollisions(Entity entity, AxisAlignedBB axisAlignedBB, Object world) {
        return Collisions.hasNoCollisions(entity, axisAlignedBB, Collections.EMPTY_SET, world);
    }

    public static boolean hasNoCollisions(Entity entity, AxisAlignedBB axisAlignedBB, Set<Entity> excludedEntities, Object world) {
        int minX = MathHelper.func_76128_c((double)(axisAlignedBB.field_72340_a - 1.0E-7)) - 1;
        int maxX = MathHelper.func_76128_c((double)(axisAlignedBB.field_72336_d + 1.0E-7)) + 1;
        int minY = MathHelper.func_76128_c((double)(axisAlignedBB.field_72338_b - 1.0E-7)) - 1;
        int maxY = MathHelper.func_76128_c((double)(axisAlignedBB.field_72337_e + 1.0E-7)) + 1;
        int minZ = MathHelper.func_76128_c((double)(axisAlignedBB.field_72339_c - 1.0E-7)) - 1;
        int maxZ = MathHelper.func_76128_c((double)(axisAlignedBB.field_72334_f + 1.0E-7)) + 1;
        ISelectionContext iselectioncontext = entity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)entity);
        CubeCoordinateIterator cubecoordinateiterator = new CubeCoordinateIterator(minX, minY, minZ, maxX, maxY, maxZ);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        VoxelShape entityVoxelShape = VoxelShapes.func_197881_a((AxisAlignedBB)axisAlignedBB);
        ArrayList<VoxelShape> allCollisionShapes = new ArrayList<VoxelShape>();
        if (entity != null) {
            world = entity.field_70170_p;
        }
        if (world instanceof IEntityReader) {
            allCollisionShapes = new ArrayList<VoxelShape>(Collisions.getEntityCollisionBoxes(entity, axisAlignedBB, excludedEntities, (IEntityReader)world));
        }
        Collisions.addShapesForBlockCollision(allCollisionShapes, cubecoordinateiterator, blockpos$mutable, world, iselectioncontext, entityVoxelShape);
        for (VoxelShape shape : allCollisionShapes) {
            if (shape.func_197766_b()) continue;
            return false;
        }
        return true;
    }

    public static List<VoxelShape> getEntityCollisionBoxes(@Nullable Entity entity, AxisAlignedBB boundingBox, Set<Entity> excludedEntities, IEntityReader world) {
        if (boundingBox.func_72320_b() < 1.0E-7) {
            return new ArrayList<VoxelShape>();
        }
        ArrayList<VoxelShape> result = new ArrayList<VoxelShape>();
        AxisAlignedBB grownBB = boundingBox.func_186662_g(1.0E-7);
        for (Entity currentEntity : world.func_72839_b(entity, grownBB)) {
            AxisAlignedBB currentCBB;
            if (currentEntity == null || entity != null && entity.func_184223_x(currentEntity) || excludedEntities.contains(currentEntity) || (currentCBB = currentEntity.func_70046_E()) == null || !grownBB.func_72326_a(currentCBB)) continue;
            result.add(VoxelShapes.func_197881_a((AxisAlignedBB)currentCBB));
        }
        return result;
    }

    private static void addShapesForBlockCollision(List<VoxelShape> shapeCollisionList, CubeCoordinateIterator cubeToCheck, BlockPos.Mutable mutablePos, Object world, ISelectionContext iselectioncontext, VoxelShape voxelShapeToCheckForCollisions) {
        while (cubeToCheck.func_218301_a()) {
            VoxelShape voxelshape2;
            VoxelShape nextShape;
            int chunkZ;
            int chunkX;
            IBlockReader iblockreader;
            int coordX = cubeToCheck.func_218304_b();
            int coordY = cubeToCheck.func_218302_c();
            int coordZ = cubeToCheck.func_218303_d();
            int numBoundariesTouched = cubeToCheck.func_223473_e();
            if (numBoundariesTouched == 3 || (iblockreader = ((ICollisionReader)world).func_225522_c_(chunkX = coordX >> 4, chunkZ = coordZ >> 4)) == null) continue;
            mutablePos.func_181079_c(coordX, coordY, coordZ);
            BlockState blockstate = iblockreader.func_180495_p((BlockPos)mutablePos);
            if (numBoundariesTouched == 1 && !blockstate.func_215704_f() || numBoundariesTouched == 2 && blockstate.func_177230_c() != Blocks.field_196603_bb || !VoxelShapes.func_197879_c((VoxelShape)voxelShapeToCheckForCollisions, (VoxelShape)(nextShape = (voxelshape2 = blockstate.func_215685_b(iblockreader, (BlockPos)mutablePos, iselectioncontext)).func_197751_a((double)coordX, (double)coordY, (double)coordZ)), (IBooleanFunction)IBooleanFunction.field_223238_i_)) continue;
            shapeCollisionList.add(nextShape);
        }
    }
}

