/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.event;

import com.mojang.brigadier.CommandDispatcher;
import com.performant.coremod.commands.EntryPoint;
import com.performant.coremod.config.ConfigurationCache;
import com.performant.coremod.entity.ai.CustomGoalSelector;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.MobEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class ForgeBusEventHandler {
    private static int serverTickTimer = 0;
    private static int meanTickCount = 0;
    private static double meanTickSum = 1.0;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityAdded(@NotNull EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof MobEntity) {
            MobEntity mob = (MobEntity)event.getEntity();
            mob.field_70715_bh = new CustomGoalSelector(mob.field_70715_bh, mob);
            mob.field_70714_bg = new CustomGoalSelector(mob.field_70714_bg, mob);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (++serverTickTimer == 20) {
            meanTickSum += (double)ForgeBusEventHandler.average(ServerLifecycleHooks.getCurrentServer().field_71311_j) * 1.0E-6;
            if (++meanTickCount >= 30) {
                ConfigurationCache.CURRENT_MEAN_TICK_TIME = meanTickSum / (double)meanTickCount;
                ConfigurationCache.TPS = 1000.0 / ConfigurationCache.CURRENT_MEAN_TICK_TIME;
                meanTickCount = 0;
                meanTickSum = 1.0;
            }
            serverTickTimer = 0;
        }
    }

    private static long average(long[] values) {
        if (values == null || values.length == 0) {
            return 0L;
        }
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartingEvent event) {
        EntryPoint.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
    }
}

