/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.reactor;

import javax.annotation.Nonnull;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.IMekanismGasHandler;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IMekanismHeatHandler;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.chemical.VariableCapacityGasTank;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.heat.HeatCapacitorHelper;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableFluidStack;
import mekanism.common.inventory.container.sync.SyncableGasStack;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.registries.MekanismGases;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.FusionReactor;
import mekanism.generators.common.GeneratorTags;
import mekanism.generators.common.item.ItemHohlraum;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.slot.ReactorInventorySlot;
import mekanism.generators.common.tile.reactor.TileEntityReactorBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityReactorController
extends TileEntityReactorBlock {
    public static final int MAX_WATER = 100000;
    public static final long MAX_STEAM = 10000000L;
    public static final long MAX_FUEL = 1000L;
    public BasicEnergyContainer energyContainer;
    public BasicHeatCapacitor heatCapacitor;
    public IExtendedFluidTank waterTank;
    public IGasTank steamTank;
    public IGasTank deuteriumTank;
    public IGasTank tritiumTank;
    public IGasTank fuelTank;
    public double plasmaTemperature;
    private AxisAlignedBB box;
    private double clientTemp = 300.0;
    private boolean clientBurning = false;
    private ReactorInventorySlot reactorSlot;
    private int localMaxWater = 100000;
    private long localMaxSteam = 10000000L;

    public TileEntityReactorController() {
        super((IBlockProvider)GeneratorsBlocks.REACTOR_CONTROLLER);
        this.addDisabledCapabilities(new Capability[]{Capabilities.GAS_HANDLER_CAPABILITY, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Capabilities.HEAT_HANDLER_CAPABILITY});
        this.addDisabledCapabilities(EnergyCompatUtils.getEnabledEnergyCapabilities());
        this.addSemiDisabledCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, () -> !this.isFormed());
    }

    @Nonnull
    protected IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideGas(() -> ((TileEntityReactorController)this).getDirection());
        this.deuteriumTank = BasicGasTank.input((long)1000L, gas -> gas.isIn(GeneratorTags.Gases.DEUTERIUM), (IMekanismGasHandler)this);
        builder.addTank((IChemicalTank)this.deuteriumTank);
        this.tritiumTank = BasicGasTank.input((long)1000L, gas -> gas.isIn(GeneratorTags.Gases.TRITIUM), (IMekanismGasHandler)this);
        builder.addTank((IChemicalTank)this.tritiumTank);
        this.fuelTank = BasicGasTank.input((long)1000L, gas -> gas.isIn(GeneratorTags.Gases.FUSION_FUEL), (IMekanismGasHandler)this);
        builder.addTank((IChemicalTank)this.fuelTank);
        this.steamTank = VariableCapacityGasTank.output(() -> this.localMaxSteam, gas -> gas == MekanismGases.STEAM.getGas(), (IMekanismGasHandler)this);
        builder.addTank((IChemicalTank)this.steamTank);
        return builder.build();
    }

    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        FluidTankHelper builder = FluidTankHelper.forSide(() -> ((TileEntityReactorController)this).getDirection());
        this.waterTank = VariableCapacityFluidTank.input(() -> this.localMaxWater, fluid -> fluid.getFluid().func_207185_a(FluidTags.field_206959_a), (IMekanismFluidHandler)this);
        builder.addTank(this.waterTank);
        return builder.build();
    }

    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(() -> ((TileEntityReactorController)this).getDirection());
        this.energyContainer = BasicEnergyContainer.output((FloatingLong)MachineEnergyContainer.validateBlock((TileEntityMekanism)this).getStorage(), (IMekanismStrictEnergyHandler)this);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    @Nonnull
    protected IHeatCapacitorHolder getInitialHeatCapacitors() {
        HeatCapacitorHelper builder = HeatCapacitorHelper.forSide(() -> ((TileEntityReactorController)this).getDirection());
        this.heatCapacitor = BasicHeatCapacitor.create((double)FusionReactor.caseHeatCapacity, (double)FusionReactor.getInverseConductionCoefficient(), (double)FusionReactor.inverseInsulation, (IMekanismHeatHandler)this);
        builder.addCapacitor((IHeatCapacitor)this.heatCapacitor);
        return builder.build();
    }

    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntityReactorController)this).getDirection());
        this.reactorSlot = ReactorInventorySlot.at(stack -> stack.func_77973_b() instanceof ItemHohlraum, (IMekanismInventory)this, 80, 39);
        builder.addSlot((IInventorySlot)this.reactorSlot);
        return builder.build();
    }

    public boolean handles(SubstanceType type) {
        if (type == SubstanceType.GAS || type == SubstanceType.FLUID || type == SubstanceType.HEAT) {
            return false;
        }
        return super.handles(type);
    }

    public ReactorInventorySlot getReactorSlot() {
        return this.reactorSlot;
    }

    @Override
    public boolean isFrame() {
        return false;
    }

    public void radiateNeutrons(int neutrons) {
    }

    @Override
    public void formMultiblock(boolean keepBurning) {
        if (this.getReactor() == null) {
            this.setReactor(new FusionReactor(this));
        }
        this.getReactor().formMultiblock(keepBurning);
    }

    public double getPlasmaTemp() {
        return this.isFormed() ? this.getReactor().getLastPlasmaTemp() : 0.0;
    }

    public double getCaseTemp() {
        return this.isFormed() ? this.getReactor().getLastCaseTemp() : 0.0;
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.isFormed()) {
            this.getReactor().simulateServer();
            if (this.getReactor().isBurning() != this.clientBurning || Math.abs(this.getReactor().getLastPlasmaTemp() - this.clientTemp) > 1000000.0) {
                this.clientBurning = this.getReactor().isBurning();
                this.clientTemp = this.getReactor().getLastPlasmaTemp();
                this.sendUpdatePacket();
            }
        }
    }

    protected boolean canPlaySound() {
        return this.isBurning();
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74780_a("plasmaTemp", this.plasmaTemperature);
        tag.func_74757_a("formed", this.isFormed());
        if (this.isFormed()) {
            tag.func_74768_a("injectionRate", this.getReactor().getInjectionRate());
            tag.func_74757_a("burning", this.getReactor().isBurning());
        }
        return tag;
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        NBTUtils.setDoubleIfPresent((CompoundNBT)tag, (String)"plasmaTemp", temp -> {
            this.plasmaTemperature = temp;
        });
        boolean formed = tag.func_74767_n("formed");
        if (formed) {
            this.setReactor(new FusionReactor(this));
            this.getReactor().setInjectionRate(tag.func_74762_e("injectionRate"));
            this.getReactor().setBurning(tag.func_74767_n("burning"));
            this.getReactor().updateTemperatures();
        }
    }

    public void updateMaxCapacities(int capRate) {
        this.localMaxWater = 100000 * capRate;
        this.localMaxSteam = 10000000L * (long)capRate;
    }

    public void setInjectionRateFromPacket(int rate) {
        if (this.getReactor() != null) {
            this.getReactor().setInjectionRate(Math.max(0, rate - rate % 2));
            this.markDirty(false);
        }
    }

    public boolean isFormed() {
        return this.getReactor() != null && this.getReactor().isFormed();
    }

    public boolean isBurning() {
        return this.isFormed() && this.getReactor().isBurning();
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active == (this.getReactor() == null)) {
            this.setReactor(active ? new FusionReactor(this) : null);
            if (!active) {
                this.invalidateCachedCapabilities();
            }
        }
    }

    public boolean renderUpdate() {
        return true;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.box == null) {
            this.box = new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 1), (double)(this.func_174877_v().func_177956_o() - 3), (double)(this.func_174877_v().func_177952_p() - 1), (double)(this.func_174877_v().func_177958_n() + 2), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() + 2));
        }
        return this.box;
    }

    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        boolean formed = this.isFormed();
        updateTag.func_74757_a("hasStructure", formed);
        if (formed) {
            updateTag.func_74780_a("plasmaTemp", this.getPlasmaTemp());
            updateTag.func_74757_a("burning", this.isBurning());
        }
        return updateTag;
    }

    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        boolean formed = tag.func_74767_n("hasStructure");
        FusionReactor reactor = this.getReactor();
        if (formed) {
            if (reactor == null || !reactor.isFormed()) {
                BlockPos corner = this.func_174877_v().func_177973_b(new Vec3i(2, 4, 2));
                Mekanism.proxy.doMultiblockSparkle((TileEntity)this, corner, 5, 5, 6, tile -> tile instanceof TileEntityReactorBlock);
            }
            if (reactor == null) {
                reactor = new FusionReactor(this);
                this.setReactor(reactor);
            }
            reactor.formed = true;
            NBTUtils.setDoubleIfPresent((CompoundNBT)tag, (String)"plasmaTemp", reactor::setLastPlasmaTemp);
            NBTUtils.setBooleanIfPresent((CompoundNBT)tag, (String)"burning", reactor::setBurning);
        } else if (reactor != null) {
            this.setReactor(null);
        }
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableDouble.create(this::getPlasmaTemp, value -> {
            if (this.getReactor() != null) {
                this.getReactor().setPlasmaTemp(value);
                this.getReactor().setLastPlasmaTemp(value);
            }
        }));
        container.track((ISyncableData)SyncableDouble.create(this::getCaseTemp, value -> {
            if (this.getReactor() != null) {
                this.getReactor().setLastCaseTemp(value);
            }
        }));
    }

    public void addFuelTabContainerTrackers(MekanismContainer container) {
        container.track((ISyncableData)SyncableInt.create(() -> this.getReactor() == null ? 0 : this.getReactor().getInjectionRate(), value -> {
            if (this.getReactor() != null) {
                this.getReactor().setInjectionRate(value);
            }
        }));
        container.track((ISyncableData)SyncableGasStack.create((IGasTank)this.fuelTank));
        container.track((ISyncableData)SyncableGasStack.create((IGasTank)this.deuteriumTank));
        container.track((ISyncableData)SyncableGasStack.create((IGasTank)this.tritiumTank));
    }

    public void addHeatTabContainerTrackers(MekanismContainer container) {
        container.track((ISyncableData)SyncableFluidStack.create((IExtendedFluidTank)this.waterTank));
        container.track((ISyncableData)SyncableGasStack.create((IGasTank)this.steamTank));
        container.track((ISyncableData)SyncableInt.create(() -> this.localMaxWater, val -> {
            this.localMaxWater = val;
        }));
        container.track((ISyncableData)SyncableLong.create(() -> this.localMaxSteam, val -> {
            this.localMaxSteam = val;
        }));
    }
}

