/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IGasProvider;
import mekanism.common.FuelHandler;
import mekanism.common.Mekanism;
import mekanism.common.Version;
import mekanism.common.base.IModule;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.MekanismModConfig;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.registries.MekanismGases;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.network.GeneratorsPacketHandler;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.registries.GeneratorsContainerTypes;
import mekanism.generators.common.registries.GeneratorsFluids;
import mekanism.generators.common.registries.GeneratorsGases;
import mekanism.generators.common.registries.GeneratorsItems;
import mekanism.generators.common.registries.GeneratorsSounds;
import mekanism.generators.common.registries.GeneratorsTileEntityTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="mekanismgenerators")
public class MekanismGenerators
implements IModule {
    public static final String MODID = "mekanismgenerators";
    public static MekanismGenerators instance;
    public final Version versionNumber;
    public static GeneratorsPacketHandler packetHandler;
    public static MultiblockManager<SynchronizedTurbineData> turbineManager;

    public MekanismGenerators() {
        instance = this;
        Mekanism.modulesLoaded.add(instance);
        MekanismGeneratorsConfig.registerConfigs(ModLoadingContext.get());
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onConfigLoad);
        GeneratorsItems.ITEMS.register(modEventBus);
        GeneratorsBlocks.BLOCKS.register(modEventBus);
        GeneratorsFluids.FLUIDS.register(modEventBus);
        GeneratorsSounds.SOUND_EVENTS.register(modEventBus);
        GeneratorsContainerTypes.CONTAINER_TYPES.register(modEventBus);
        GeneratorsTileEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
        GeneratorsGases.GASES.register(modEventBus);
        this.versionNumber = new Version(ModLoadingContext.get().getActiveContainer().getModInfo().getVersion());
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        FuelHandler.addGas((IGasProvider)MekanismGases.ETHENE, (int)MekanismConfig.general.ETHENE_BURN_TIME.get(), (FloatingLong)((FloatingLong)MekanismConfig.general.FROM_H2.get()).add(((FloatingLong)MekanismGeneratorsConfig.generators.bioGeneration.get()).multiply(2L * (long)MekanismConfig.general.ETHENE_BURN_TIME.get())));
        MinecraftForge.EVENT_BUS.register((Object)this);
        packetHandler.initialize();
        Mekanism.logger.info("Loaded 'Mekanism Generators' module.");
    }

    public Version getVersion() {
        return this.versionNumber;
    }

    public String getName() {
        return "Generators";
    }

    public void resetClient() {
        SynchronizedTurbineData.clientRotationMap.clear();
    }

    private void onConfigLoad(ModConfig.ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals(MODID) && config instanceof MekanismModConfig) {
            ((MekanismModConfig)config).clearCache();
        }
    }

    static {
        packetHandler = new GeneratorsPacketHandler();
        turbineManager = new MultiblockManager("industrialTurbine");
    }
}

