/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.util.Arrays;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.generators.client.gui.element.GuiTurbineTab;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiTurbineStats
extends GuiMekanismTile<TileEntityTurbineCasing, EmptyTileContainer<TileEntityTurbineCasing>> {
    public GuiTurbineStats(EmptyTileContainer<TileEntityTurbineCasing> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    public void init() {
        super.init();
        this.addButton((Widget)new GuiTurbineTab((IGuiWrapper)this, (TileEntityTurbineCasing)this.tile, GuiTurbineTab.TurbineTab.MAIN));
        this.addButton((Widget)new GuiEnergyInfo(() -> {
            EnergyDisplay producing;
            EnergyDisplay storing;
            if (((TileEntityTurbineCasing)this.tile).structure == null) {
                storing = EnergyDisplay.ZERO;
                producing = EnergyDisplay.ZERO;
            } else {
                storing = EnergyDisplay.of((FloatingLong)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).energyContainer.getEnergy(), (FloatingLong)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).energyContainer.getMaxEnergy());
                producing = EnergyDisplay.of((FloatingLong)((FloatingLong)MekanismConfig.general.maxEnergyPerSteam.get()).divide(28L).multiply(((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).clientFlow * (long)Math.min(((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).blades, ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).coils * MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get())));
            }
            return Arrays.asList(MekanismLang.STORING.translate(new Object[]{storing}), GeneratorsLang.PRODUCING_AMOUNT.translate(new Object[]{producing}));
        }, (IGuiWrapper)this));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawCenteredText((ITextComponent)GeneratorsLang.TURBINE_STATS.translate(new Object[0]), 0, this.getXSize(), 6, 0x404040);
        if (((TileEntityTurbineCasing)this.tile).structure != null) {
            ITextComponent limiting = GeneratorsLang.IS_LIMITING.translateColored(EnumColor.DARK_RED, new Object[0]);
            int lowerVolume = ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).lowerVolume;
            int clientDispersers = ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).clientDispersers;
            int vents = ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).vents;
            this.drawString((ITextComponent)GeneratorsLang.TURBINE_TANK_VOLUME.translate(new Object[]{lowerVolume}), 8, 26, 0x404040);
            boolean dispersersLimiting = (double)(lowerVolume * clientDispersers) * MekanismGeneratorsConfig.generators.turbineDisperserGasFlow.get() < (double)vents * MekanismGeneratorsConfig.generators.turbineVentGasFlow.get();
            boolean ventsLimiting = (double)(lowerVolume * clientDispersers) * MekanismGeneratorsConfig.generators.turbineDisperserGasFlow.get() > (double)vents * MekanismGeneratorsConfig.generators.turbineVentGasFlow.get();
            this.drawString((ITextComponent)GeneratorsLang.TURBINE_STEAM_FLOW.translate(new Object[0]), 8, 40, 0x797979);
            this.drawString((ITextComponent)GeneratorsLang.TURBINE_DISPERSERS.translate(new Object[]{clientDispersers, dispersersLimiting ? limiting : ""}), 14, 49, 0x404040);
            this.drawString((ITextComponent)GeneratorsLang.TURBINE_VENTS.translate(new Object[]{vents, ventsLimiting ? limiting : ""}), 14, 58, 0x404040);
            int coils = ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).coils;
            int blades = ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).blades;
            this.drawString((ITextComponent)GeneratorsLang.TURBINE_PRODUCTION.translate(new Object[0]), 8, 72, 0x797979);
            this.drawString((ITextComponent)GeneratorsLang.TURBINE_BLADES.translate(new Object[]{blades, coils * 4 > blades ? limiting : ""}), 14, 81, 0x404040);
            this.drawString((ITextComponent)GeneratorsLang.TURBINE_COILS.translate(new Object[]{coils, coils * 4 < blades ? limiting : ""}), 14, 90, 0x404040);
            FloatingLong energyMultiplier = ((FloatingLong)MekanismConfig.general.maxEnergyPerSteam.get()).divide(28L).multiply((long)Math.min(blades, coils * MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get()));
            double rate = (double)lowerVolume * ((double)clientDispersers * MekanismGeneratorsConfig.generators.turbineDisperserGasFlow.get());
            rate = Math.min(rate, (double)vents * MekanismGeneratorsConfig.generators.turbineVentGasFlow.get());
            this.drawString((ITextComponent)GeneratorsLang.TURBINE_MAX_PRODUCTION.translate(new Object[]{EnergyDisplay.of((FloatingLong)energyMultiplier.multiply(rate))}), 8, 104, 0x404040);
            this.drawString((ITextComponent)GeneratorsLang.TURBINE_MAX_WATER_OUTPUT.translate(new Object[]{((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tile).structure).condensers * MekanismGeneratorsConfig.generators.condenserRate.get()}), 8, 113, 0x404040);
        }
        super.func_146979_b(mouseX, mouseY);
    }
}

