/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.parts;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.parts.IPartMaterial;
import net.silentchaos512.gear.crafting.ingredient.CustomTippedUpgradeIngredient;

public class PartMaterial
implements IPartMaterial {
    private Ingredient normal = Ingredient.field_193370_a;
    private Ingredient small = Ingredient.field_193370_a;

    PartMaterial() {
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return this.normal.test(itemStack);
    }

    @Override
    public Ingredient getNormal() {
        return this.normal;
    }

    @Override
    public Ingredient getSmall() {
        return this.small;
    }

    public static PartMaterial deserialize(ResourceLocation partId, JsonObject json) {
        PartMaterial material = new PartMaterial();
        if (json.has("custom_tipped_upgrade")) {
            material.normal = CustomTippedUpgradeIngredient.of(partId);
        } else if (json.has("normal")) {
            material.normal = PartMaterial.deserialize(partId, json.get("normal"));
        } else if (json.has("uncraftable")) {
            material.normal = Ingredient.field_193370_a;
        } else {
            throw new JsonSyntaxException("Missing non-small crafting_items");
        }
        if (json.has("small")) {
            material.small = PartMaterial.deserialize(partId, json.get("small"));
        }
        return material;
    }

    public static PartMaterial read(PacketBuffer buffer) {
        PartMaterial material = new PartMaterial();
        material.normal = Ingredient.func_199566_b((PacketBuffer)buffer);
        material.small = Ingredient.func_199566_b((PacketBuffer)buffer);
        return material;
    }

    private static Ingredient deserialize(ResourceLocation partId, JsonElement json) {
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            if (obj.has("item") && obj.has("tag")) {
                SilentGear.LOGGER.warn("Part '{}' has a crafting item with both an 'item' and 'tag' property. Ignoring 'item'.", (Object)partId);
                obj.remove("item");
            }
            if (obj.has("tag")) {
                ResourceLocation tagId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)obj, (String)"tag"));
                if (ItemTags.func_199903_a().func_199910_a(tagId) == null) {
                    SilentGear.LOGGER.warn("Unknown item tag '{}' on part '{}'. Part will not be usable for crafting.", (Object)tagId, (Object)partId);
                    return Ingredient.field_193370_a;
                }
            }
            return Ingredient.func_199802_a((JsonElement)obj);
        }
        return CraftingHelper.getIngredient((JsonElement)json);
    }
}

