/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.blueprint;

import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.item.blueprint.BlueprintType;

public abstract class AbstractBlueprintItem
extends Item {
    final boolean singleUse;

    AbstractBlueprintItem(Item.Properties properties, boolean singleUse) {
        super(properties);
        this.singleUse = singleUse;
    }

    protected abstract ITextComponent getCraftedName(ItemStack var1);

    public ItemStack getContainerItem(ItemStack itemStack) {
        return itemStack.func_77946_l();
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !this.singleUse;
    }

    boolean isDisabled() {
        BlueprintType config = (BlueprintType)Config.GENERAL.blueprintTypes.get();
        return this.singleUse && !config.allowTemplate() || !this.singleUse && !config.allowBlueprint();
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.isDisabled()) {
            super.func_150895_a(group, items);
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        String key = "item.silentgear." + (this.singleUse ? "template" : "blueprint");
        return new TranslationTextComponent(key, new Object[]{this.getCraftedName(stack)});
    }

    public Rarity func_77613_e(ItemStack stack) {
        return this.singleUse ? Rarity.COMMON : Rarity.UNCOMMON;
    }
}

