/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.CrimsonIronOre;
import net.silentchaos512.gear.block.FlaxPlant;
import net.silentchaos512.gear.block.MetalBlock;
import net.silentchaos512.gear.block.NetherwoodLeaves;
import net.silentchaos512.gear.block.NetherwoodLog;
import net.silentchaos512.gear.block.NetherwoodPlanks;
import net.silentchaos512.gear.block.NetherwoodSapling;
import net.silentchaos512.gear.block.NetherwoodSlab;
import net.silentchaos512.gear.block.NetherwoodStairs;
import net.silentchaos512.gear.block.PhantomLight;
import net.silentchaos512.gear.block.StoneTorch;
import net.silentchaos512.gear.block.StoneTorchWall;
import net.silentchaos512.gear.block.craftingstation.CraftingStationBlock;
import net.silentchaos512.gear.block.salvager.SalvagerBlock;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.lib.block.IBlockProvider;
import net.silentchaos512.utils.Lazy;

public enum ModBlocks implements IBlockProvider,
IStringSerializable
{
    CRIMSON_IRON_ORE(CrimsonIronOre::new),
    CRIMSON_IRON_BLOCK(() -> new MetalBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(3.0f, 6.0f).func_200947_a(SoundType.field_185852_e))),
    CRIMSON_STEEL_BLOCK(() -> new MetalBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(3.0f, 6.0f).func_200947_a(SoundType.field_185852_e))),
    CRAFTING_STATION(CraftingStationBlock::new),
    SALVAGER(SalvagerBlock::new),
    FLAX_PLANT(() -> new FlaxPlant(false), () -> null),
    WILD_FLAX_PLANT(() -> new FlaxPlant(true), () -> null),
    STONE_TORCH(StoneTorch::new, ModBlocks::getStoneTorchItem),
    WALL_STONE_TORCH(StoneTorchWall::new, () -> null),
    NETHERWOOD_LOG(NetherwoodLog::new),
    NETHERWOOD_PLANKS(NetherwoodPlanks::new),
    NETHERWOOD_SLAB(NetherwoodSlab::new),
    NETHERWOOD_STAIRS(NetherwoodStairs::new),
    NETHERWOOD_LEAVES(NetherwoodLeaves::new),
    NETHERWOOD_SAPLING(NetherwoodSapling::new),
    POTTED_NETHERWOOD_SAPLING(() -> ModBlocks.makePottedPlant(NETHERWOOD_SAPLING::asBlock), () -> null),
    PHANTOM_LIGHT(PhantomLight::new);

    private final Lazy<Block> block;
    private final Lazy<BlockItem> item;

    private ModBlocks(Supplier<Block> blockSupplier) {
        this.block = Lazy.of(blockSupplier);
        this.item = Lazy.of(() -> new BlockItem(this.asBlock(), new Item.Properties().func_200916_a(SilentGear.ITEM_GROUP)));
    }

    private ModBlocks(Supplier<Block> blockSupplier, Supplier<BlockItem> itemBlockSupplier) {
        this.block = Lazy.of(blockSupplier);
        this.item = Lazy.of(itemBlockSupplier);
    }

    public static void registerAll(RegistryEvent.Register<Block> event) {
        if (!event.getName().equals((Object)ForgeRegistries.BLOCKS.getRegistryName())) {
            return;
        }
        for (ModBlocks block : ModBlocks.values()) {
            ModBlocks.register(block.func_176610_l(), block.asBlock(), (BlockItem)block.item.get());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderTypes(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)FLAX_PLANT.asBlock(), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)NETHERWOOD_SAPLING.asBlock(), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)POTTED_NETHERWOOD_SAPLING.asBlock(), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)STONE_TORCH.asBlock(), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)WALL_STONE_TORCH.asBlock(), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)WILD_FLAX_PLANT.asBlock(), (RenderType)RenderType.func_228643_e_());
    }

    private static void register(String name, Block block, @Nullable BlockItem item) {
        ResourceLocation registryName = new ResourceLocation("silentgear", name);
        block.setRegistryName(registryName);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        if (item != null) {
            ModItems.blocksToRegister.put(name, item);
        }
    }

    private static BlockItem getStoneTorchItem() {
        return new WallOrFloorItem(STONE_TORCH.asBlock(), WALL_STONE_TORCH.asBlock(), new Item.Properties());
    }

    private static FlowerPotBlock makePottedPlant(Supplier<Block> flower) {
        FlowerPotBlock potted = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.field_150457_bL.delegate.get(), flower, Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(0.0f));
        ResourceLocation flowerId = Objects.requireNonNull(flower.get().getRegistryName());
        ((FlowerPotBlock)Blocks.field_150457_bL).addPlant(flowerId, () -> potted);
        return potted;
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public Block asBlock() {
        return (Block)this.block.get();
    }

    public Item func_199767_j() {
        return this.asBlock().func_199767_j();
    }
}

