/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.event;

import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.util.GearHelper;

@Mod.EventBusSubscriber(modid="silentgear")
public final class ToolBlockPlaceHandler {
    private ToolBlockPlaceHandler() {
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
    }

    private static ActionResultType useItemAsPlayer(ItemUseContext context) {
        return context.func_195996_i().func_196084_a(context);
    }

    private static boolean canToolPlaceBlock(ItemStack stack) {
        if (stack.func_77973_b() instanceof ICoreItem && GearHelper.isBroken(stack)) {
            return false;
        }
        return Config.GENERAL.isPlacerTool(stack);
    }

    private static boolean canPlaceBlockAt(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return false;
        }
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        ItemStack usedStack = context.func_195996_i();
        if (usedStack.func_77973_b() instanceof BlockItem) {
            Block block = ((BlockItem)usedStack.func_77973_b()).func_179223_d();
            BlockItemUseContext blockContext = new BlockItemUseContext(context);
            if (block.func_176223_P().func_196953_a(blockContext)) {
                pos = pos.func_177972_a(side);
            }
        }
        return player.func_175151_a(pos, side, usedStack);
    }

    private static boolean itemNotPlaceable(ItemStack stack) {
        return stack.func_190926_b() || stack.func_77942_o() && stack.func_196082_o().func_74764_b("NoPlacing") || !(stack.func_77973_b() instanceof BlockItem) && !Config.GENERAL.isPlaceableItem(stack);
    }
}

