/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.event;

import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.IUpgradePart;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.RepairContext;
import net.silentchaos512.gear.util.GearData;

@Mod.EventBusSubscriber(modid="silentgear")
public final class RepairHandler {
    private RepairHandler() {
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        PartData part;
        if (event.getLeft().func_77973_b() instanceof ICoreItem && (part = PartData.from(event.getRight())) != null) {
            if (part.getPart() instanceof IUpgradePart) {
                RepairHandler.handleUpgradeApplication(event, part);
            } else if (part.getType() == PartType.MAIN) {
                RepairHandler.handleGearRepair(event, part);
            }
        }
    }

    private static void handleUpgradeApplication(AnvilUpdateEvent event, PartData part) {
        ItemStack result = event.getLeft().func_77946_l();
        GearData.addUpgradePart(result, part);
        GearData.recalculateStats(result, null);
        event.setOutput(result);
        event.setCost(3);
    }

    private static void handleGearRepair(AnvilUpdateEvent event, PartData part) {
        ItemStack result = event.getLeft().func_77946_l();
        float amount = part.getRepairAmount(result, RepairContext.Type.ANVIL);
        int materialCount = 1;
        for (float repaired = amount *= GearData.getStat(result, ItemStats.REPAIR_EFFICIENCY); materialCount < event.getRight().func_190916_E() && repaired < (float)result.func_77952_i(); ++materialCount, repaired += amount) {
        }
        if (amount > 0.0f) {
            result.func_96631_a(-Math.round(amount * (float)materialCount), SilentGear.random, null);
            GearData.recalculateStats(result, null);
            event.setOutput(result);
            event.setCost(materialCount);
            event.setMaterialCost(materialCount);
        }
    }

    private static boolean canRepairTogether(ItemStack first, ItemStack second) {
        return first.func_77973_b() == second.func_77973_b() && first.func_77973_b() instanceof ICoreItem && second.func_77973_b() instanceof ICoreItem && GearData.getTier(first) <= GearData.getTier(second);
    }

    private static ItemStack copyCurses(ItemStack first, ItemStack second) {
        ItemStack itemstack = first.func_77946_l();
        Map map = EnchantmentHelper.func_82781_a((ItemStack)second);
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            if (enchantment.func_190936_d() && EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)itemstack) != 0) continue;
            itemstack.func_77966_a(enchantment, ((Integer)entry.getValue()).intValue());
        }
        return itemstack;
    }

    private static ItemStack createGrindstoneResult(ItemStack stack, int newDamage) {
        ItemStack itemstack = stack.func_77946_l();
        itemstack.func_196083_e("Enchantments");
        itemstack.func_196083_e("StoredEnchantments");
        if (newDamage > 0) {
            itemstack.func_196085_b(newDamage);
        } else {
            itemstack.func_196083_e("Damage");
        }
        Map<Enchantment, Integer> map = EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet().stream().filter(p_217012_0_ -> ((Enchantment)p_217012_0_.getKey()).func_190936_d()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        EnchantmentHelper.func_82782_a(map, (ItemStack)itemstack);
        itemstack.func_82841_c(0);
        if (itemstack.func_77973_b() == Items.field_151134_bR && map.isEmpty()) {
            itemstack = new ItemStack((IItemProvider)Items.field_151122_aG);
            if (stack.func_82837_s()) {
                itemstack.func_200302_a(stack.func_200301_q());
            }
        }
        for (int i = 0; i < map.size(); ++i) {
            itemstack.func_82841_c(RepairContainer.func_216977_d((int)itemstack.func_82838_A()));
        }
        return itemstack;
    }
}

