/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.event;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.traits.TraitConst;
import net.silentchaos512.gear.traits.TraitManager;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.advancements.LibTriggers;

@Mod.EventBusSubscriber
public final class GearEvents {
    private static final ResourceLocation APPLY_TIP_UPGRADE = SilentGear.getId("apply_tip_upgrade");
    private static final ResourceLocation MAX_DURABILITY = SilentGear.getId("max_durability");
    private static final ResourceLocation REPAIR_FROM_BROKEN = SilentGear.getId("repair_from_broken");
    private static final ResourceLocation UNIQUE_MAIN_PARTS = SilentGear.getId("unique_main_parts");
    private static final Set<UUID> entityAttackedThisTick = new HashSet<UUID>();

    private GearEvents() {
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent events) {
        entityAttackedThisTick.clear();
    }

    @SubscribeEvent
    public static void onAttackEntity(LivingAttackEvent event) {
        LivingEntity attacked = event.getEntityLiving();
        if (attacked == null || entityAttackedThisTick.contains(attacked.func_110124_au())) {
            return;
        }
        DamageSource source = event.getSource();
        if (source == null || !"player".equals(source.field_76373_n)) {
            return;
        }
        Entity attacker = source.func_76346_g();
        if (!(attacker instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)attacker;
        ItemStack weapon = player.func_184614_ca();
        if (!(weapon.func_77973_b() instanceof ICoreTool)) {
            return;
        }
        float baseDamage = event.getAmount();
        float newDamage = TraitHelper.activateTraits(weapon, baseDamage, (trait, level, value) -> trait.onAttackEntity(new TraitActionContext(player, level, weapon), attacked, baseDamage));
        if (Math.abs(newDamage - baseDamage) > 1.0E-4f) {
            event.setCanceled(true);
            entityAttackedThisTick.add(attacked.func_110124_au());
            attacked.func_70097_a(source, newDamage);
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        PlayerEntity player = event.getPlayer();
        ItemStack tool = player.func_184614_ca();
        if (tool.func_77973_b() instanceof ICoreItem) {
            boolean canHarvest;
            BlockState state = event.getState();
            ToolType toolClass = state.func_177230_c().getHarvestTool(state);
            int blockLevel = state.func_177230_c().getHarvestLevel(state);
            int toolLevel = tool.func_77973_b().getHarvestLevel(tool, toolClass, player, state);
            boolean bl = canHarvest = toolLevel >= blockLevel;
            if (canHarvest) {
                ITrait lustrous = TraitManager.get(TraitConst.LUSTROUS);
                int level = TraitHelper.getTraitLevel(tool, lustrous);
                int light = GearEvents.getLightForLustrousTrait((ILightReader)player.field_70170_p, player.func_180425_c());
                event.setNewSpeed(event.getOriginalSpeed() + (float)GearEvents.getLustrousSpeedBonus(level, light));
            }
        }
    }

    public static int getLightForLustrousTrait(ILightReader world, BlockPos pos) {
        int blockLight = world.func_226658_a_(LightType.BLOCK, pos);
        int skyLight = world.func_226658_a_(LightType.SKY, pos);
        return Math.max(skyLight, blockLight * 3 / 4);
    }

    public static int getLustrousSpeedBonus(int level, int light) {
        return 4 * level * light / 15;
    }

    @Deprecated
    @SubscribeEvent
    public static void onBlockDrops(BlockEvent.HarvestDropsEvent event) {
        PlayerEntity harvester = event.getHarvester();
        if (harvester == null || event.isSilkTouching()) {
            return;
        }
        if (!(harvester instanceof ServerPlayerEntity)) {
            return;
        }
        ItemStack tool = harvester.func_184614_ca();
        if (tool.func_190926_b() || !(tool.func_77973_b() instanceof ICoreTool)) {
            return;
        }
        int magmaticLevel = TraitHelper.getTraitLevel(tool, TraitConst.MAGMATIC);
        if (magmaticLevel == 0) {
            return;
        }
        for (int i = 0; i < event.getDrops().size(); ++i) {
            ItemStack smelted;
            ItemStack stack = (ItemStack)event.getDrops().get(i);
            ServerWorld world = ((ServerPlayerEntity)harvester).func_71121_q();
            Optional recipe = world.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{stack}), (World)world);
            if (!recipe.isPresent() || (smelted = ((FurnaceRecipe)recipe.get()).func_77571_b()).func_190926_b()) continue;
            ItemStack copy = smelted.func_77946_l();
            copy.func_190920_e(stack.func_190916_E());
            event.getDrops().remove(i);
            event.getDrops().add(i, copy);
        }
    }

    @SubscribeEvent
    public static void onXpDrop(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() == null) {
            return;
        }
        ItemStack tool = event.getAttackingPlayer().func_184614_ca();
        if (tool.func_190926_b() || !(tool.func_77973_b() instanceof ICoreTool)) {
            return;
        }
        int ancientLevel = TraitHelper.getTraitLevel(tool, TraitConst.ANCIENT);
        if (ancientLevel == 0) {
            return;
        }
        int bonusXp = (int)((float)event.getOriginalExperience() * 0.25f * (float)ancientLevel);
        event.setDroppedExperience(event.getDroppedExperience() + bonusXp);
    }

    @SubscribeEvent
    public static void onBlockXpDrop(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        ItemStack tool = event.getPlayer().func_184614_ca();
        if (tool.func_190926_b() || !(tool.func_77973_b() instanceof ICoreTool)) {
            return;
        }
        int ancientLevel = TraitHelper.getTraitLevel(tool, TraitConst.ANCIENT);
        if (ancientLevel == 0) {
            return;
        }
        int bonusXp = (int)((float)event.getExpToDrop() * 0.25f * (float)ancientLevel);
        event.setExpToDrop(event.getExpToDrop() + bonusXp);
    }

    @SubscribeEvent
    public static void onGearCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack result = event.getCrafting();
        if (!(result.func_77973_b() instanceof ICoreItem)) {
            return;
        }
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            int brokenCount = GearData.getBrokenCount(result);
            int repairCount = GearData.getRepairCount(result);
            if (brokenCount > 0 && repairCount > 0) {
                LibTriggers.GENERIC_INT.trigger(player, REPAIR_FROM_BROKEN, brokenCount);
            }
            LibTriggers.GENERIC_INT.trigger(player, MAX_DURABILITY, result.func_77958_k());
            PartDataList parts = GearData.getConstructionParts(result);
            if (!parts.getTips().isEmpty()) {
                LibTriggers.GENERIC_INT.trigger(player, APPLY_TIP_UPGRADE, 1);
            }
            int mainCount = parts.getUniqueParts(true).size();
            SilentGear.LOGGER.debug("mainCount = {}", (Object)mainCount);
            LibTriggers.GENERIC_INT.trigger(player, UNIQUE_MAIN_PARTS, mainCount);
        }
    }
}

