/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.salvager;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraft.util.IItemProvider;
import net.silentchaos512.gear.SilentGear;

final class VanillaGearSalvage {
    private static final Collection<Item> ITEMS = ImmutableList.of((Object)Items.field_151048_u, (Object)Items.field_151010_B, (Object)Items.field_151040_l, (Object)Items.field_151052_q, (Object)Items.field_151041_m, (Object)Items.field_151046_w, (Object)Items.field_151005_D, (Object)Items.field_151035_b, (Object)Items.field_151050_s, (Object)Items.field_151039_o, (Object)Items.field_151047_v, (Object)Items.field_151011_C, (Object[])new Item[]{Items.field_151037_a, Items.field_151051_r, Items.field_151038_n, Items.field_151056_x, Items.field_151006_E, Items.field_151036_c, Items.field_151049_t, Items.field_151053_p, Items.field_151012_L, Items.field_151013_M, Items.field_151019_K, Items.field_151018_J, Items.field_151017_I, Items.field_151021_T, Items.field_151027_R, Items.field_151024_Q, Items.field_151026_S, Items.field_151029_X, Items.field_151023_V, Items.field_151020_U, Items.field_151022_W, Items.field_151167_ab, Items.field_151030_Z, Items.field_151028_Y, Items.field_151165_aa, Items.field_151151_aj, Items.field_151171_ah, Items.field_151169_ag, Items.field_151149_ai, Items.field_151175_af, Items.field_151163_ad, Items.field_151161_ac, Items.field_151173_ae});

    private VanillaGearSalvage() {
    }

    static boolean isVanillaGear(ItemStack stack) {
        return ITEMS.contains(stack.func_77973_b());
    }

    static int getHeadCount(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ShovelItem) {
            return 1;
        }
        if (item instanceof SwordItem || item instanceof HoeItem) {
            return 2;
        }
        if (item instanceof PickaxeItem || item instanceof AxeItem) {
            return 3;
        }
        if (item instanceof ArmorItem) {
            int multi = Objects.requireNonNull(item.getRegistryName()).func_110623_a().startsWith("chainmail") ? 4 : 1;
            EquipmentSlotType type = ((ArmorItem)item).func_185083_B_();
            if (type == EquipmentSlotType.CHEST) {
                return 8 * multi;
            }
            if (type == EquipmentSlotType.FEET) {
                return 4 * multi;
            }
            if (type == EquipmentSlotType.HEAD) {
                return 5 * multi;
            }
            if (type == EquipmentSlotType.LEGS) {
                return 7 * multi;
            }
        }
        SilentGear.LOGGER.warn("Tried to salvage '{}' as vanilla gear, but could not identify item type", (Object)stack);
        return 0;
    }

    static int getRodCount(ItemStack stack) {
        if (stack.func_77973_b() instanceof ArmorItem) {
            return 0;
        }
        if (stack.func_77973_b() instanceof ArmorItem) {
            return 1;
        }
        return 2;
    }

    @Nullable
    static IItemProvider getHeadItem(ItemStack stack) {
        String name = Objects.requireNonNull(stack.func_77973_b().getRegistryName()).func_110623_a();
        if (name.startsWith("diamond")) {
            return Items.field_151045_i;
        }
        if (name.startsWith("golden")) {
            return Items.field_151043_k;
        }
        if (name.startsWith("iron")) {
            return Items.field_151042_j;
        }
        if (name.startsWith("stone")) {
            return Blocks.field_150347_e;
        }
        if (name.startsWith("wooden")) {
            return Blocks.field_196662_n;
        }
        if (name.startsWith("leather")) {
            return Items.field_151116_aA;
        }
        if (name.startsWith("chainmail")) {
            return Items.field_191525_da;
        }
        SilentGear.LOGGER.warn("Don't know salvage head part for vanilla gear '{}'", (Object)stack);
        return null;
    }
}

