/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.traits;

import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.client.KeyTracker;

public interface ITrait {
    public ResourceLocation getId();

    public int getMaxLevel();

    public boolean willCancelWith(ITrait var1);

    default public int getCanceledLevel(int level, ITrait other, int otherLevel) {
        if (this.willCancelWith(other)) {
            int diff = level - otherLevel;
            return diff < 0 ? MathHelper.func_76125_a((int)diff, (int)(-other.getMaxLevel()), (int)0) : MathHelper.func_76125_a((int)diff, (int)0, (int)this.getMaxLevel());
        }
        return level;
    }

    public ITextComponent getDisplayName(int var1);

    public ITextComponent getDescription(int var1);

    default public boolean isHidden() {
        return false;
    }

    default public boolean showInTooltip(ITooltipFlag flag) {
        return !this.isHidden() || flag.func_194127_a();
    }

    @Deprecated
    default public void addInformation(int level, List<ITextComponent> tooltip) {
        this.addInformation(level, tooltip, () -> false);
    }

    default public void addInformation(int level, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (!this.showInTooltip(flag)) {
            return;
        }
        ITextComponent displayName = this.getDisplayName(level).func_211708_a(TextFormatting.ITALIC);
        if (this.isHidden()) {
            displayName.func_211708_a(TextFormatting.DARK_GRAY);
        }
        tooltip.add(displayName);
        if (KeyTracker.isAltDown()) {
            ITextComponent description = this.getDescription(level).func_211708_a(TextFormatting.DARK_GRAY);
            tooltip.add(new StringTextComponent("  ").func_150257_a(description));
        }
    }

    public ITraitSerializer<?> getSerializer();

    public float onAttackEntity(TraitActionContext var1, LivingEntity var2, float var3);

    public float onDurabilityDamage(TraitActionContext var1, int var2);

    public void onGearCrafted(TraitActionContext var1);

    public float onGetStat(TraitActionContext var1, ItemStat var2, float var3, float var4);

    public void onGetAttributeModifiers(TraitActionContext var1, Multimap<String, AttributeModifier> var2, EquipmentSlotType var3);

    public ActionResultType onItemUse(ItemUseContext var1, int var2);

    public void onUpdate(TraitActionContext var1, boolean var2);

    default public CompoundNBT write(int level) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("Name", this.getId().toString());
        tag.func_74774_a("Level", (byte)level);
        return tag;
    }
}

