/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.tileentity.loader;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import xyz.brassgoggledcoders.transport.capability.EnergyStorageDirectional;
import xyz.brassgoggledcoders.transport.content.TransportBlocks;
import xyz.brassgoggledcoders.transport.tileentity.loader.BasicLoaderTileEntity;

public class EnergyLoaderTileEntity
extends BasicLoaderTileEntity<IEnergyStorage> {
    private final EnergyStorageComponent energyComponent = new EnergyStorageComponent(10000, 79, 24);
    private final LazyOptional<IEnergyStorage> lazyEnergy = LazyOptional.of(() -> this.energyComponent);

    public EnergyLoaderTileEntity() {
        super(TransportBlocks.ENERGY_LOADER.getTileEntityType(), CapabilityEnergy.ENERGY);
    }

    @Override
    protected void transfer(IEnergyStorage from, IEnergyStorage to) {
        int amountSimPushed;
        int amountSimPulled = from.extractEnergy(10000, true);
        if (amountSimPulled > 0 && (amountSimPushed = to.receiveEnergy(amountSimPulled, true)) > 0) {
            to.receiveEnergy(from.extractEnergy(amountSimPushed, false), false);
        }
    }

    @Override
    protected LazyOptional<IEnergyStorage> getInternalCAP() {
        return this.lazyEnergy;
    }

    @Override
    protected LazyOptional<IEnergyStorage> createOutputCAP() {
        return LazyOptional.of(() -> new EnergyStorageDirectional((IEnergyStorage)this.energyComponent, false));
    }

    @Override
    protected LazyOptional<IEnergyStorage> createInputCAP() {
        return LazyOptional.of(() -> new EnergyStorageDirectional((IEnergyStorage)this.energyComponent, true));
    }

    @Override
    protected CompoundNBT serializeCap() {
        return this.energyComponent.serializeNBT();
    }

    @Override
    protected void deserializeCap(CompoundNBT compoundNBT) {
        this.energyComponent.deserializeNBT(compoundNBT);
    }

    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        return this.energyComponent.getScreenAddons();
    }

    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        return this.energyComponent.getContainerAddons();
    }
}

