/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.datagen.loot;

import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.SlabBlock;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.ILootFunctionConsumer;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.BlockStateProperty;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.functions.CopyBlockState;
import net.minecraft.world.storage.loot.functions.CopyNbt;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.brassgoggledcoders.transport.block.ScaffoldingSlabBlock;
import xyz.brassgoggledcoders.transport.block.loader.LoaderBlock;
import xyz.brassgoggledcoders.transport.content.TransportBlocks;

public class TransportBlockLootTables
extends BlockLootTables {
    @Nonnull
    protected Iterable<Block> getKnownBlocks() {
        return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> Optional.ofNullable(block.getRegistryName()).filter(registryName -> registryName.func_110624_b().equals("transport")).isPresent()).collect(Collectors.toList());
    }

    protected void addTables() {
        this.registerLoader(TransportBlocks.ITEM_LOADER.getBlock());
        this.registerLoader(TransportBlocks.ENERGY_LOADER.getBlock());
        this.registerLoader(TransportBlocks.FLUID_LOADER.getBlock());
        this.func_218492_c(TransportBlocks.DIAMOND_CROSSING_RAIL.getBlock());
        this.func_218492_c(TransportBlocks.HOLDING_RAIL.getBlock());
        this.func_218492_c(TransportBlocks.ELEVATOR_SWITCH_RAIL.getBlock());
        this.func_218507_a((Block)TransportBlocks.ELEVATOR_SWITCH_SUPPORT.get(), LootTable.func_216119_b());
        this.func_218492_c(TransportBlocks.SCAFFOLDING_RAIL.getBlock());
        this.func_218492_c(TransportBlocks.SWITCH_RAIL.getBlock());
        this.func_218492_c(TransportBlocks.WYE_SWITCH_RAIL.getBlock());
        this.func_218492_c(TransportBlocks.BUMPER_RAIL.getBlock());
        this.func_218492_c(TransportBlocks.MODULE_CONFIGURATOR.getBlock());
        this.func_218522_a(TransportBlocks.SCAFFOLDING_SLAB_BLOCK.getBlock(), block -> LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227195_a_((IProperty)ScaffoldingSlabBlock.RAILED, false))).func_216045_a((LootEntry.Builder)TransportBlockLootTables.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE))))))));
    }

    private void registerLoader(Block loader) {
        CopyBlockState.Builder copyBlockStateBuilder = CopyBlockState.func_227545_a_((Block)loader);
        IntStream.range(0, Direction.values().length).mapToObj(Direction::func_82600_a).map(LoaderBlock.PROPERTIES::get).forEach(arg_0 -> ((CopyBlockState.Builder)copyBlockStateBuilder).func_227552_a_(arg_0));
        this.func_218507_a(loader, new LootTable.Builder().func_216040_a(LootPool.func_216096_a().func_212841_b_((ILootFunction.IBuilder)copyBlockStateBuilder).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a("capability", "BlockEntityTag.capability")).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)1.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)loader))));
    }
}

