/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.block.rail.elevatorswitch;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.brassgoggledcoders.transport.block.rail.elevatorswitch.ElevatorSwitchSupportBlock;
import xyz.brassgoggledcoders.transport.content.TransportBlocks;

public class ElevatorSwitchRailBlock
extends AbstractRailBlock {
    public static final EnumProperty<RailShape> SHAPE = EnumProperty.func_177708_a((String)"shape", RailShape.class, RailShape::func_208092_c);
    public static final BooleanProperty TOP = BooleanProperty.func_177716_a((String)"top");

    public ElevatorSwitchRailBlock(Block.Properties properties) {
        super(true, properties);
    }

    public ElevatorSwitchRailBlock() {
        this(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.7f).func_200947_a(SoundType.field_185852_e));
    }

    public static BlockState oppositeAscend(BlockState railState) {
        switch ((RailShape)railState.func_177229_b(SHAPE)) {
            case ASCENDING_EAST: {
                return (BlockState)railState.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
            }
            case ASCENDING_WEST: {
                return (BlockState)railState.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
            }
            case ASCENDING_NORTH: {
                return (BlockState)railState.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
            }
            case ASCENDING_SOUTH: {
                return (BlockState)railState.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
            }
        }
        return railState;
    }

    @ParametersAreNonnullByDefault
    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        BlockPos downPos;
        BlockState downState;
        super.func_180657_a(world, player, pos, state, te, stack);
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue() && (downState = world.func_180495_p(downPos = pos.func_177977_b())).func_177230_c() == TransportBlocks.ELEVATOR_SWITCH_SUPPORT.get()) {
            downState.removedByPlayer(world, downPos, player, true, world.func_204610_c(downPos));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{SHAPE, TOP});
    }

    @Nonnull
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = super.func_176223_P();
        Direction direction = context.func_195992_f();
        switch (direction) {
            case NORTH: {
                blockstate = (BlockState)blockstate.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                break;
            }
            case EAST: {
                blockstate = (BlockState)blockstate.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                break;
            }
            case SOUTH: {
                blockstate = (BlockState)blockstate.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                break;
            }
            case WEST: {
                blockstate = (BlockState)blockstate.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
            }
        }
        return (BlockState)blockstate.func_206870_a((IProperty)TOP, (Comparable)Boolean.valueOf(false));
    }

    @Nonnull
    public IProperty<RailShape> func_176560_l() {
        return SHAPE;
    }

    @ParametersAreNonnullByDefault
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.updateState(worldIn, pos, state);
    }

    private void updateState(World world, BlockPos pos, BlockState state) {
        if (!((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            boolean powered = world.func_175640_z(pos);
            if (powered && world.func_175623_d(pos.func_177984_a())) {
                world.func_175656_a(pos, ((ElevatorSwitchSupportBlock)TransportBlocks.ELEVATOR_SWITCH_SUPPORT.get()).func_176223_P());
                world.func_175656_a(pos.func_177984_a(), (BlockState)ElevatorSwitchRailBlock.oppositeAscend(state).func_206870_a((IProperty)TOP, (Comparable)Boolean.valueOf(true)));
            }
        } else if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != TransportBlocks.ELEVATOR_SWITCH_SUPPORT.get()) {
            Block.func_220075_c((BlockState)state, (World)world, (BlockPos)pos);
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        }
    }
}

