/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api.routing.serializer;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import xyz.brassgoggledcoders.transport.api.routing.instruction.Routing;
import xyz.brassgoggledcoders.transport.api.routing.serializer.RoutingDeserializer;

public class ListValidatedRoutingDeserializer<T>
extends RoutingDeserializer {
    private final Function<List<T>, Either<String, Routing>> constructor;
    private final Class<T> clazz;

    public ListValidatedRoutingDeserializer(Class<T> clazz, Function<List<T>, Either<String, Routing>> constructor) {
        this.constructor = constructor;
        this.clazz = clazz;
    }

    @Override
    @Nonnull
    public Either<String, Routing> deserialize(List<Object> inputs) {
        ArrayList values = Lists.newArrayList();
        for (Object input : inputs) {
            if (this.clazz.isInstance(input)) {
                values.add(this.clazz.cast(input));
                continue;
            }
            return Either.left((Object)("Found " + this.clazz.getName() + " Expected " + input.getClass().getName()));
        }
        if (!values.isEmpty()) {
            return this.constructor.apply(values);
        }
        return Either.left((Object)"Expected at least 1. Found 0.");
    }
}

