/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api.routing;

import com.mojang.datafixers.util.Either;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.WritableBookItem;
import net.minecraft.item.WrittenBookItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.LecternTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import xyz.brassgoggledcoders.transport.api.routing.RoutingParser;
import xyz.brassgoggledcoders.transport.api.routing.instruction.Routing;

public class RoutingStorage {
    private Either<String, Routing> routing = null;

    @Nonnull
    public Either<String, Routing> getRouting(TileEntity tileEntity) {
        if (this.routing == null) {
            if (tileEntity instanceof LecternTileEntity) {
                LecternTileEntity lecternTileEntity = (LecternTileEntity)tileEntity;
                if (lecternTileEntity.func_214046_f()) {
                    ItemStack book = lecternTileEntity.func_214033_c();
                    String routingString = null;
                    if (WrittenBookItem.func_77828_a((CompoundNBT)book.func_77978_p())) {
                        CompoundNBT bookNBT = book.func_77978_p();
                        ListNBT pagesNBT = bookNBT.func_150295_c("pages", 8);
                        String currentPage = pagesNBT.func_150307_f(lecternTileEntity.func_214041_g());
                        ITextComponent textComponent = ITextComponent.Serializer.func_150699_a((String)currentPage);
                        if (textComponent != null) {
                            routingString = textComponent.getString();
                        }
                    } else if (WritableBookItem.func_150930_a((CompoundNBT)book.func_77978_p())) {
                        CompoundNBT bookNBT = book.func_77978_p();
                        ListNBT pagesNBT = bookNBT.func_150295_c("pages", 8);
                        routingString = pagesNBT.func_150307_f(lecternTileEntity.func_214041_g());
                    }
                    this.routing = routingString != null ? RoutingParser.parse(routingString) : Either.left((Object)"Found Invalid Book");
                } else {
                    this.routing = Either.left((Object)"No Book found");
                }
            } else {
                this.routing = Either.left((Object)"Didn't find Lectern");
            }
        }
        return this.routing;
    }

    public void invalidate() {
        this.routing = null;
    }
}

